/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1697")
public class NullDereferenceInConditionalCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Either reverse the equality operator in the \"%s\" null test, or reverse the logical operator that follows it.";

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (NullDereferenceInConditionalCheck.isAndWithEqualToNull(tree) || NullDereferenceInConditionalCheck.isOrWithNonEqualToNull(tree)) {
            BinaryExpressionTree leftOperand = (BinaryExpressionTree)CheckUtils.removeParenthesis(tree.leftOperand());
            ExpressionTree expression = CheckUtils.removeParenthesis(NullDereferenceInConditionalCheck.getNonNullLiteralOperand(leftOperand));
            tree.rightOperand().accept((DoubleDispatchVisitor)new NullExpressionUsageVisitor(expression, (JavaScriptCheck)this));
        }
        super.visitBinaryExpression(tree);
    }

    private static ExpressionTree getNonNullLiteralOperand(BinaryExpressionTree binaryExpressionTree) {
        if (NullDereferenceInConditionalCheck.isNullOrUndefined((Tree)binaryExpressionTree.leftOperand())) {
            return binaryExpressionTree.rightOperand();
        }
        return binaryExpressionTree.leftOperand();
    }

    private static boolean isAndWithEqualToNull(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND}) && NullDereferenceInConditionalCheck.isNullComparison(tree.leftOperand(), Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO);
    }

    private static boolean isOrWithNonEqualToNull(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR}) && NullDereferenceInConditionalCheck.isNullComparison(tree.leftOperand(), Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO);
    }

    private static boolean isNullComparison(ExpressionTree expression, Tree.Kind kind1, Tree.Kind kind2) {
        ExpressionTree tree = CheckUtils.removeParenthesis(expression);
        if (tree.is(new Tree.Kind[]{kind1, kind2})) {
            BinaryExpressionTree binaryExp = (BinaryExpressionTree)tree;
            return NullDereferenceInConditionalCheck.isNullOrUndefined((Tree)binaryExp.leftOperand()) || NullDereferenceInConditionalCheck.isNullOrUndefined((Tree)binaryExp.rightOperand());
        }
        return false;
    }

    private static boolean isNullOrUndefined(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "undefined".equals(((IdentifierTree)tree).identifierToken().text());
    }

    private static class NullExpressionUsageVisitor
    extends DoubleDispatchVisitorCheck {
        private ExpressionTree nullExpression;
        private JavaScriptCheck check;

        NullExpressionUsageVisitor(ExpressionTree nullExpression, JavaScriptCheck check) {
            this.nullExpression = nullExpression;
            this.check = check;
        }

        public void visitMemberExpression(MemberExpressionTree tree) {
            if (SyntacticEquivalence.areEquivalent((Tree)tree.object(), (Tree)this.nullExpression)) {
                this.check.addIssue((Tree)this.nullExpression, String.format(NullDereferenceInConditionalCheck.MESSAGE, CheckUtils.asString((Tree)this.nullExpression)));
            }
            super.visitMemberExpression(tree);
        }
    }
}

