/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="PrimitiveWrappers")
public class PrimitiveWrappersCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use a literal value for this.";
    private static final Set<String> WRAPPERS = ImmutableSet.of((Object)"Boolean", (Object)"Number", (Object)"String");

    public void visitNewExpression(NewExpressionTree tree) {
        if (WRAPPERS.contains(CheckUtils.asString((Tree)tree.expression()))) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitNewExpression(tree);
    }
}

