/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S3499")
public class ShorthandPropertiesNotGroupedCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE_PATTERN = "Group all shorthand properties at the %s of this object declaration";
    private static final String MESSAGE = "Group all shorthand properties at either the beginning or end of this object declaration.";
    private static final String SECONDARY_MESSAGE_PATTERN = "Move to the %s.";
    private static final String SECONDARY_MESSAGE = "Group at beginning or end.";

    public void visitObjectLiteral(ObjectLiteralTree tree) {
        ArrayList<Boolean> isShorthandPropertyList = new ArrayList<Boolean>();
        int shorthandPropertiesNumber = 0;
        boolean containsSpreadProperty = false;
        for (Tree propertyTree : tree.properties()) {
            if (propertyTree.is(new Tree.Kind[]{Tree.Kind.SPREAD_ELEMENT})) {
                containsSpreadProperty = true;
                break;
            }
            boolean isShorthandProperty = ShorthandPropertiesNotGroupedCheck.isShorthand(propertyTree);
            isShorthandPropertyList.add(isShorthandProperty);
            shorthandPropertiesNumber += isShorthandProperty ? 1 : 0;
        }
        if (!containsSpreadProperty && shorthandPropertiesNumber > 0) {
            this.analyseShorthandPropertiesPosition(tree, isShorthandPropertyList, shorthandPropertiesNumber);
        }
        super.visitObjectLiteral(tree);
    }

    private void analyseShorthandPropertiesPosition(ObjectLiteralTree tree, List<Boolean> isShorthandPropertyList, int shorthandPropertiesNumber) {
        int numberOfShorthandAtBeginning = ShorthandPropertiesNotGroupedCheck.getNumberOfTrueAtBeginning(isShorthandPropertyList);
        int numberOfShorthandAtEnd = ShorthandPropertiesNotGroupedCheck.getNumberOfTrueAtBeginning(Lists.reverse(isShorthandPropertyList));
        boolean allAtBeginning = numberOfShorthandAtBeginning == shorthandPropertiesNumber;
        boolean allAtEnd = numberOfShorthandAtEnd == shorthandPropertiesNumber;
        int propertiesNumber = tree.properties().size();
        if (!allAtBeginning && numberOfShorthandAtBeginning > numberOfShorthandAtEnd) {
            this.raiseIssuePattern(tree, numberOfShorthandAtBeginning, propertiesNumber, "beginning");
        } else if (!allAtEnd && numberOfShorthandAtEnd > numberOfShorthandAtBeginning) {
            this.raiseIssuePattern(tree, 0, propertiesNumber - numberOfShorthandAtEnd, "end");
        } else if (!allAtBeginning && !allAtEnd) {
            this.raiseIssue(tree, 0, propertiesNumber, MESSAGE, SECONDARY_MESSAGE);
        }
    }

    private void raiseIssuePattern(ObjectLiteralTree tree, int begin, int end, String place) {
        this.raiseIssue(tree, begin, end, String.format(MESSAGE_PATTERN, place), String.format(SECONDARY_MESSAGE_PATTERN, place));
    }

    private void raiseIssue(ObjectLiteralTree tree, int begin, int end, String primaryMessage, String secondaryMessage) {
        PreciseIssue preciseIssue = this.addIssue((Tree)tree.openCurlyBrace(), primaryMessage);
        for (int i = begin; i < end; ++i) {
            if (!ShorthandPropertiesNotGroupedCheck.isShorthand((Tree)tree.properties().get(i))) continue;
            preciseIssue.secondary((Tree)tree.properties().get(i), secondaryMessage);
        }
    }

    private static boolean isShorthand(Tree propertyTree) {
        return propertyTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE});
    }

    private static int getNumberOfTrueAtBeginning(List<Boolean> list) {
        int numberOfTrueAtBeginning = 0;
        for (Boolean element : list) {
            if (!element.booleanValue()) break;
            ++numberOfTrueAtBeginning;
        }
        return numberOfTrueAtBeginning;
    }
}

