/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S930")
public class TooManyArgumentsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "%s expects %s argument%s, but %s %s provided.";

    public void visitCallExpression(CallExpressionTree tree) {
        FunctionTree functionTree = TooManyArgumentsCheck.getFunction(tree);
        if (functionTree != null) {
            int parametersNumber = functionTree.parameterList().size();
            int argumentsNumber = tree.arguments().parameters().size();
            if (!TooManyArgumentsCheck.hasRestParameter(functionTree) && !this.builtInArgumentsUsed(functionTree) && argumentsNumber > parametersNumber) {
                String message = TooManyArgumentsCheck.getMessage(tree, parametersNumber, argumentsNumber);
                this.addIssue((Tree)tree.arguments(), message).secondary(functionTree.parameterClause(), "Formal parameters");
            }
        }
        super.visitCallExpression(tree);
    }

    private static String getMessage(CallExpressionTree tree, int parametersNumber, int argumentsNumber) {
        String callee = CheckUtils.removeParenthesis(tree.callee()).is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION}) ? "This function" : "\"" + CheckUtils.asString((Tree)tree.callee()) + "\"";
        return String.format(MESSAGE, callee, parametersNumber, parametersNumber == 1 ? "" : "s", argumentsNumber, argumentsNumber > 1 ? "were" : "was");
    }

    private static boolean hasRestParameter(FunctionTree functionTree) {
        List parameters = functionTree.parameterList();
        return !parameters.isEmpty() && ((Tree)parameters.get(parameters.size() - 1)).is(new Tree.Kind[]{Tree.Kind.REST_ELEMENT});
    }

    @Nullable
    private static FunctionTree getFunction(CallExpressionTree tree) {
        TypeSet types = tree.callee().types();
        if (types.size() == 1 && ((Type)types.iterator().next()).kind().equals((Object)Type.Kind.FUNCTION)) {
            return ((FunctionType)types.iterator().next()).functionTree();
        }
        return null;
    }

    private boolean builtInArgumentsUsed(FunctionTree tree) {
        Scope scope = this.getContext().getSymbolModel().getScope((Tree)tree);
        if (scope == null) {
            throw new IllegalStateException("No scope found for FunctionTree");
        }
        Symbol argumentsBuiltInVariable = scope.lookupSymbol("arguments");
        if (argumentsBuiltInVariable == null) {
            if (!tree.is(new Tree.Kind[]{Tree.Kind.ARROW_FUNCTION})) {
                throw new IllegalStateException("No 'arguments' symbol found for function scope");
            }
            return false;
        }
        boolean isUsed = !argumentsBuiltInVariable.usages().isEmpty();
        return argumentsBuiltInVariable.builtIn() && isUsed;
    }
}

