/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="TrailingComma")
public class TrailingCommaCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this trailing comma.";

    public void visitObjectLiteral(ObjectLiteralTree tree) {
        SeparatedList separatedList = tree.properties();
        int listSize = separatedList.size();
        if (listSize > 0 && listSize == separatedList.getSeparators().size()) {
            InternalSyntaxToken trailingComma = separatedList.getSeparator(listSize - 1);
            this.raiseIssue((Tree)trailingComma);
        }
        super.visitObjectLiteral(tree);
    }

    public void visitArrayLiteral(ArrayLiteralTree tree) {
        List elementsAndCommas = tree.elementsAndCommas();
        if (!elementsAndCommas.isEmpty()) {
            Tree last = (Tree)elementsAndCommas.get(elementsAndCommas.size() - 1);
            if (last.is(new Tree.Kind[]{Tree.Kind.TOKEN})) {
                this.raiseIssue(last);
            }
        }
        super.visitArrayLiteral(tree);
    }

    private void raiseIssue(Tree trailingComma) {
        this.addIssue(trailingComma, MESSAGE);
    }
}

