/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.EnumSet;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAllPathSeCheck;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

@Rule(key="S3002")
public class UnaryPlusMinusWithObjectCheck
extends AbstractAllPathSeCheck<UnaryExpressionTree> {
    private static final String MESSAGE = "Remove this use of unary \"%s\".";
    private static final EnumSet<Type> NOT_ALLOWED_TYPES = EnumSet.of(Type.OTHER_OBJECT, Type.ARRAY, Type.FUNCTION, Type.OBJECT);

    @Override
    UnaryExpressionTree getTree(Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS})) {
            return (UnaryExpressionTree)element;
        }
        return null;
    }

    @Override
    boolean isProblem(UnaryExpressionTree tree, ProgramState currentState) {
        Constraint constraint = currentState.getConstraint(currentState.peekStack());
        Type type = constraint.type();
        return type != null && NOT_ALLOWED_TYPES.contains(type);
    }

    @Override
    void raiseIssue(UnaryExpressionTree tree) {
        if (!UnaryPlusMinusWithObjectCheck.isDateException((Tree)tree)) {
            SyntaxToken operator = tree.operator();
            this.addIssue((Tree)operator, String.format(MESSAGE, operator.text()));
        }
    }

    private static boolean isDateException(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.UNARY_PLUS})) {
            String exprString = CheckUtils.asString((Tree)((UnaryExpressionTree)tree).expression());
            return exprString.contains("Date") || exprString.contains("date");
        }
        return false;
    }
}

