/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="UnreachableCode")
public class UnreachableCodeCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove this code after the \"%s\" statement.";
    private static final String MESSAGE_WITHOUT_KEYWORD = "Remove this unreachable code.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().addAll((Iterable)TreeKinds.functionKinds()).add((Object)Tree.Kind.SCRIPT).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SCRIPT})) {
            this.check(ControlFlowGraph.build((ScriptTree)((ScriptTree)tree)));
        } else {
            FunctionTree functionTree = (FunctionTree)tree;
            if (functionTree.body().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                this.check(ControlFlowGraph.build((BlockTree)((BlockTree)functionTree.body())));
            }
        }
    }

    private void check(ControlFlowGraph cfg) {
        for (CfgBlock unreachable : cfg.unreachableBlocks()) {
            Tree element = UnreachableCodeCheck.unreachableTree(unreachable.elements());
            if (element == null) continue;
            Set disconnectingJumps = cfg.disconnectingJumps(unreachable);
            String message = MESSAGE_WITHOUT_KEYWORD;
            if (disconnectingJumps.size() == 1) {
                SyntaxToken keyword = (SyntaxToken)disconnectingJumps.iterator().next();
                message = String.format(MESSAGE, keyword.text());
            }
            PreciseIssue issue = this.addIssue(element, message);
            for (SyntaxToken jump : disconnectingJumps) {
                issue.secondary((Tree)jump);
            }
        }
    }

    private static Tree unreachableTree(List<Tree> elements) {
        List<Tree> unreachableElements = UnreachableCodeCheck.skipDeclarations(elements);
        if (unreachableElements.isEmpty()) {
            return null;
        }
        Tree biggestUnreachableElement = unreachableElements.get(0);
        for (Tree element : unreachableElements) {
            if (UnreachableCodeCheck.startIndex(element) > UnreachableCodeCheck.startIndex(biggestUnreachableElement) || UnreachableCodeCheck.endIndex(element) < UnreachableCodeCheck.endIndex(biggestUnreachableElement)) continue;
            biggestUnreachableElement = element;
        }
        return biggestUnreachableElement;
    }

    private static List<Tree> skipDeclarations(List<Tree> elements) {
        int i = 0;
        for (Tree element : elements) {
            if (!element.is(new Tree.Kind[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.CLASS_DECLARATION})) {
                return elements.subList(i, elements.size());
            }
            ++i;
        }
        return ImmutableList.of();
    }

    private static int startIndex(Tree element) {
        InternalSyntaxToken firstToken = (InternalSyntaxToken)((JavaScriptTree)element).getFirstToken();
        return firstToken.startIndex();
    }

    private static int endIndex(Tree element) {
        InternalSyntaxToken lastToken = (InternalSyntaxToken)((JavaScriptTree)element).getLastToken();
        return lastToken.toIndex();
    }
}

