/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Iterator;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S3513")
public class ArgumentsUsageCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use the rest syntax to declare this function's arguments.";

    public void visitScript(ScriptTree tree) {
        for (Symbol argumentsSymbol : this.getContext().getSymbolModel().getSymbols("arguments")) {
            if (!argumentsSymbol.builtIn() || argumentsSymbol.usages().isEmpty()) continue;
            Iterator usageIterator = argumentsSymbol.usages().iterator();
            PreciseIssue preciseIssue = this.addIssue((Tree)((Usage)usageIterator.next()).identifierTree(), MESSAGE);
            while (usageIterator.hasNext()) {
                preciseIssue.secondary((Tree)((Usage)usageIterator.next()).identifierTree());
            }
        }
    }
}

