/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S3757")
public class ArithmeticOperationReturningNanCheck
extends SeCheck {
    private static final String MESSAGE = "Change the expression which uses this operand so that it can't evaluate to \"NaN\" (Not a Number).";
    private static final Constraint NUMBER_OR_BOOLEAN = Constraint.ANY_NUMBER.or(Constraint.ANY_BOOLEAN);
    private static final Constraint NUMBER_OR_BOOLEAN_OR_UNDEFINED = NUMBER_OR_BOOLEAN.or(Constraint.UNDEFINED);
    private static final Constraint NUMBER_LIKE_OBJECT = Constraint.NUMBER_OBJECT.or(Constraint.BOOLEAN_OBJECT).or(Constraint.DATE);
    private static final Constraint UNDEFINED_OR_NON_NUMBER_OBJECT = Constraint.UNDEFINED.or(Constraint.OBJECT.and(NUMBER_LIKE_OBJECT.not()));
    private final BinaryOperationChecker plusChecker = new PlusChecker();
    private final BinaryOperationChecker otherBinaryOperationChecker = new OtherBinaryOperationChecker();
    private final Set<Symbol> symbolsWithIssues = new HashSet<Symbol>();
    private final Set<Tree> operandsWithIssues = new HashSet<Tree>();

    public void startOfExecution(Scope functionScope) {
        this.symbolsWithIssues.clear();
        super.startOfExecution(functionScope);
    }

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        Constraint constraint;
        if (element.is(new Tree.Kind[]{Tree.Kind.PLUS, Tree.Kind.PLUS_ASSIGNMENT})) {
            ArithmeticOperationReturningNanCheck.checkBinaryOperation(currentState, element, this.plusChecker);
        } else if (element.is(new Tree.Kind[]{Tree.Kind.MINUS, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT})) {
            ArithmeticOperationReturningNanCheck.checkBinaryOperation(currentState, element, this.otherBinaryOperationChecker);
        } else if (element.is(new Tree.Kind[]{Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT}) && (constraint = currentState.getConstraint(currentState.peekStack(0))).isStricterOrEqualTo(UNDEFINED_OR_NON_NUMBER_OBJECT)) {
            UnaryExpressionTree unaryExpression = (UnaryExpressionTree)element;
            this.raiseIssue((Tree)unaryExpression.expression(), new Tree[]{unaryExpression.operator()});
        }
    }

    private void raiseIssue(Tree operand, Tree ... secondaryLocations) {
        Symbol operandSymbol = null;
        if (operand.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            IdentifierTree identifier = (IdentifierTree)operand;
            operandSymbol = identifier.symbol();
        }
        if (!this.symbolsWithIssues.contains(operandSymbol) && !this.operandsWithIssues.contains(operand)) {
            PreciseIssue issue = this.addIssue(operand, MESSAGE);
            Arrays.asList(secondaryLocations).forEach(arg_0 -> ((PreciseIssue)issue).secondary(arg_0));
            if (operandSymbol != null) {
                this.symbolsWithIssues.add(operandSymbol);
            }
            this.operandsWithIssues.add(operand);
        }
    }

    private static void checkBinaryOperation(ProgramState currentState, Tree element, BinaryOperationChecker checker) {
        SyntaxToken operator;
        ExpressionTree rightOperand;
        ExpressionTree leftOperand;
        Constraint rightConstraint = currentState.getConstraint(currentState.peekStack(0));
        Constraint leftConstraint = currentState.getConstraint(currentState.peekStack(1));
        if (element instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)element;
            leftOperand = assignment.variable();
            rightOperand = assignment.expression();
            operator = assignment.operator();
        } else {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)element;
            leftOperand = binaryExpression.leftOperand();
            rightOperand = binaryExpression.rightOperand();
            operator = binaryExpression.operator();
        }
        checker.check(leftConstraint, rightConstraint, (Tree)leftOperand, (Tree)rightOperand, (Tree)operator);
    }

    private class OtherBinaryOperationChecker
    implements BinaryOperationChecker {
        private OtherBinaryOperationChecker() {
        }

        @Override
        public void check(Constraint leftConstraint, Constraint rightConstraint, Tree leftOperand, Tree rightOperand, Tree operator) {
            if (leftConstraint.isStricterOrEqualTo(UNDEFINED_OR_NON_NUMBER_OBJECT)) {
                ArithmeticOperationReturningNanCheck.this.raiseIssue(leftOperand, new Tree[]{operator, rightOperand});
            } else if (rightConstraint.isStricterOrEqualTo(UNDEFINED_OR_NON_NUMBER_OBJECT)) {
                ArithmeticOperationReturningNanCheck.this.raiseIssue(rightOperand, new Tree[]{operator, leftOperand});
            }
        }
    }

    private class PlusChecker
    implements BinaryOperationChecker {
        private PlusChecker() {
        }

        @Override
        public void check(Constraint leftConstraint, Constraint rightConstraint, Tree leftOperand, Tree rightOperand, Tree operator) {
            if (this.isAdditionWithUndefined(rightConstraint, leftConstraint)) {
                ArithmeticOperationReturningNanCheck.this.raiseIssue(leftOperand, new Tree[]{operator, rightOperand});
            } else if (this.isAdditionWithUndefined(leftConstraint, rightConstraint)) {
                ArithmeticOperationReturningNanCheck.this.raiseIssue(rightOperand, new Tree[]{operator, leftOperand});
            }
        }

        private boolean isAdditionWithUndefined(Constraint constraint1, Constraint constraint2) {
            return constraint1.isStricterOrEqualTo(NUMBER_OR_BOOLEAN_OR_UNDEFINED) && constraint2.isStricterOrEqualTo(Constraint.UNDEFINED);
        }
    }

    @FunctionalInterface
    private static interface BinaryOperationChecker {
        public void check(Constraint var1, Constraint var2, Tree var3, Tree var4, Tree var5);
    }
}

