/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2549")
public class BackboneChangedIsUsedCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this update of the \"changed\" property.";
    private static final String CHANGED = "changed";

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (variable.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && BackboneChangedIsUsedCheck.isChangedPropertyAccess((DotMemberExpressionTree)variable)) {
            this.addIssue((Tree)((DotMemberExpressionTree)variable).property(), MESSAGE);
        }
        super.visitAssignmentExpression(tree);
    }

    private static boolean isChangedPropertyAccess(DotMemberExpressionTree tree) {
        return tree.property().name().equals(CHANGED) && tree.object().types().contains(Type.Kind.BACKBONE_MODEL_OBJECT);
    }
}

