/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3525")
public class ClassPrototypeCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Declare a \"%s\" class and move this declaration of \"%s\" into it.";

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        DotMemberExpressionTree prototype;
        DotMemberExpressionTree lhs;
        if (tree.variable().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && tree.expression().types().containsOnlyAndUnique(Type.Kind.FUNCTION) && (lhs = (DotMemberExpressionTree)tree.variable()).object().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && "prototype".equals((prototype = (DotMemberExpressionTree)lhs.object()).property().name()) && prototype.object().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && prototype.object().types().contains(Type.Kind.FUNCTION)) {
            this.addIssue((Tree)lhs, String.format(MESSAGE, ((IdentifierTree)prototype.object()).name(), lhs.property().name()));
        }
        super.visitAssignmentExpression(tree);
    }
}

