/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="CollapsibleIfStatements")
public class CollapsibleIfStatementsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Merge this if statement with the nested one.";
    private static final String SECONDARY_MESSAGE = "Nested \"if\" statement";

    public void visitIfStatement(IfStatementTree tree) {
        IfStatementTree innerIfStatement;
        if (tree.elseClause() == null && (innerIfStatement = CollapsibleIfStatementsCheck.getCollapsibleIfStatement(tree.statement())) != null) {
            IssueLocation primaryLocation = CollapsibleIfStatementsCheck.issueLocation(tree, MESSAGE);
            IssueLocation secondaryLocation = CollapsibleIfStatementsCheck.issueLocation(innerIfStatement, SECONDARY_MESSAGE);
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, primaryLocation).secondary(secondaryLocation));
        }
        super.visitIfStatement(tree);
    }

    private static IssueLocation issueLocation(IfStatementTree tree, String message) {
        return new IssueLocation((Tree)tree.ifKeyword(), (Tree)tree.closeParenthesis(), message);
    }

    @Nullable
    private static IfStatementTree getCollapsibleIfStatement(StatementTree statement) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)statement;
            if (block.statements().size() == 1) {
                return CollapsibleIfStatementsCheck.getIfStatementWithoutElse((StatementTree)block.statements().get(0));
            }
        } else {
            return CollapsibleIfStatementsCheck.getIfStatementWithoutElse(statement);
        }
        return null;
    }

    @Nullable
    private static IfStatementTree getIfStatementWithoutElse(StatementTree statement) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && ((IfStatementTree)statement).elseClause() == null) {
            return (IfStatementTree)statement;
        }
        return null;
    }
}

