/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.se.LiveVariableAnalysis;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1854")
public class DeadStoreCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this useless assignment to local variable \"%s\"";

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitFunctionDeclaration(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitFunctionExpression(tree);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitMethodDeclaration(tree);
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitArrowFunction(tree);
    }

    private void checkFunction(FunctionTree functionTree) {
        if (!functionTree.body().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            return;
        }
        this.checkCFG(ControlFlowGraph.build((BlockTree)((BlockTree)functionTree.body())), functionTree);
    }

    private void checkCFG(ControlFlowGraph cfg, FunctionTree functionTree) {
        Scope scope = this.getContext().getSymbolModel().getScope((Tree)functionTree);
        LiveVariableAnalysis lva = LiveVariableAnalysis.create((ControlFlowGraph)cfg, (Scope)scope);
        LiveVariableAnalysis.Usages usages = lva.getUsages();
        for (CfgBlock cfgBlock : cfg.blocks()) {
            Set live = lva.getLiveOutSymbols(cfgBlock);
            for (Tree element : Lists.reverse((List)cfgBlock.elements())) {
                Usage usage = usages.getUsage(element);
                if (usage == null) continue;
                this.checkUsage(usage, live, usages);
            }
        }
        this.raiseIssuesForNeverReadSymbols(usages);
    }

    private void checkUsage(Usage usage, Set<Symbol> liveSymbols, LiveVariableAnalysis.Usages usages) {
        Symbol symbol = usage.symbol();
        if (LiveVariableAnalysis.isWrite((Usage)usage)) {
            if (!(liveSymbols.contains(symbol) || usages.hasUsagesInNestedFunctions(symbol) || usages.neverReadSymbols().contains(symbol))) {
                this.addIssue((Tree)usage.identifierTree(), symbol);
            }
            liveSymbols.remove(symbol);
        } else if (LiveVariableAnalysis.isRead((Usage)usage)) {
            liveSymbols.add(symbol);
        }
    }

    private void raiseIssuesForNeverReadSymbols(LiveVariableAnalysis.Usages usages) {
        for (Symbol symbol : usages.neverReadSymbols()) {
            for (Usage usage : symbol.usages()) {
                if (!LiveVariableAnalysis.isWrite((Usage)usage)) continue;
                this.addIssue((Tree)usage.identifierTree(), symbol);
            }
        }
    }

    private void addIssue(Tree element, Symbol symbol) {
        this.addIssue(element, String.format(MESSAGE, symbol.name()));
    }
}

