/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;

@Rule(key="S1871")
public class DuplicateBranchImplementationCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Either merge this %s with the identical one on line \"%s\" or change one of the implementations.";
    private static final String CONDITIONAL_EXPRESSION_MESSAGE = "This conditional operation returns the same value whether the condition is \"true\" or \"false\".";

    public void visitIfStatement(IfStatementTree tree) {
        StatementTree implementation = tree.statement();
        ElseClauseTree elseClause = tree.elseClause();
        while (elseClause != null) {
            StatementTree implementationToCompare = DuplicateBranchImplementationCheck.getImplementationFromElseClause(elseClause);
            if (SyntacticEquivalence.areEquivalent((Tree)implementation, (Tree)implementationToCompare)) {
                this.addIssue((Tree)implementation, (Tree)implementationToCompare, "branch");
                break;
            }
            elseClause = this.getNextElse(elseClause);
        }
        super.visitIfStatement(tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        for (int i = 0; i < tree.cases().size(); ++i) {
            SwitchClauseTree caseTree = (SwitchClauseTree)tree.cases().get(i);
            if (caseTree.statements().isEmpty() || DuplicateBranchImplementationCheck.isCaseEndingWithoutJumpStmt(caseTree)) continue;
            this.compareWithNextCases(tree, i, caseTree);
        }
    }

    private void compareWithNextCases(SwitchStatementTree tree, int indexCaseReference, SwitchClauseTree caseTree) {
        for (int j = indexCaseReference + 1; j < tree.cases().size(); ++j) {
            List caseStatements;
            SwitchClauseTree caseTreeToCompare = (SwitchClauseTree)tree.cases().get(j);
            if (caseTreeToCompare.statements().isEmpty() || DuplicateBranchImplementationCheck.isCaseEndingWithoutJumpStmt(caseTreeToCompare)) continue;
            List list = caseStatements = caseTreeToCompare.is(new Tree.Kind[]{Tree.Kind.DEFAULT_CLAUSE}) ? caseTree.statements().subList(0, caseTree.statements().size() - 1) : caseTree.statements();
            if (!SyntacticEquivalence.areEquivalent((List)caseStatements, (List)caseTreeToCompare.statements())) continue;
            this.addIssue((Tree)caseTree, (Tree)caseTreeToCompare, "case");
            break;
        }
    }

    private void addIssue(Tree original, Tree duplicate, String type) {
        IssueLocation secondary = new IssueLocation(original, "Original");
        String message = String.format(MESSAGE, type, secondary.startLine());
        this.addIssue(duplicate, message).secondary(secondary);
    }

    private static boolean isCaseEndingWithoutJumpStmt(SwitchClauseTree caseTree) {
        return caseTree.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE}) && !DuplicateBranchImplementationCheck.isJumpStatement((StatementTree)Iterables.getLast((Iterable)caseTree.statements()));
    }

    private static boolean isJumpStatement(StatementTree statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.THROW_STATEMENT});
    }

    private static StatementTree getImplementationFromElseClause(ElseClauseTree elseClause) {
        return elseClause.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) ? ((IfStatementTree)elseClause.statement()).statement() : elseClause.statement();
    }

    public ElseClauseTree getNextElse(ElseClauseTree elseClause) {
        return elseClause.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) ? ((IfStatementTree)elseClause.statement()).elseClause() : null;
    }

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        if (SyntacticEquivalence.areEquivalent((Tree)tree.trueExpression(), (Tree)tree.falseExpression())) {
            this.addIssue((Tree)tree.query(), CONDITIONAL_EXPRESSION_MESSAGE).secondary((Tree)tree.trueExpression()).secondary((Tree)tree.falseExpression());
        }
        super.visitConditionalExpression(tree);
    }
}

