/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAllPathSeCheck;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

@Rule(key="EqEqEq")
public class EqEqEqCheck
extends AbstractAllPathSeCheck<BinaryExpressionTree> {
    private Set<BinaryExpressionTree> ignoredList = new HashSet<BinaryExpressionTree>();
    private static final Tree.Kind[] EQUALITY_KINDS = new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO};

    @Override
    BinaryExpressionTree getTree(Tree element) {
        if (element.is(EQUALITY_KINDS)) {
            return (BinaryExpressionTree)element;
        }
        return null;
    }

    @Override
    boolean isProblem(BinaryExpressionTree tree, ProgramState currentState) {
        Constraint rightConstraint = currentState.getConstraint(currentState.peekStack(0));
        Constraint leftConstraint = currentState.getConstraint(currentState.peekStack(1));
        Type rightType = rightConstraint.type();
        Type leftType = leftConstraint.type();
        return leftType != null && leftType == rightType;
    }

    @Override
    void raiseIssue(BinaryExpressionTree tree) {
        this.ignoredList.add(tree);
    }

    public void startOfFile(ScriptTree scriptTree) {
        this.ignoredList.clear();
    }

    public void endOfFile(ScriptTree scriptTree) {
        EqualityVisitor equalityVisitor = new EqualityVisitor();
        equalityVisitor.scanTree((Tree)scriptTree);
        equalityVisitor.equalityExpressions.stream().filter(equalityExpression -> !this.ignoredList.contains(equalityExpression)).forEach(equalityExpression -> this.addIssue((Tree)equalityExpression.operator(), equalityExpression.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) ? "Replace \"==\" with \"===\"." : "Replace \"!=\" with \"!==\".").secondary((Tree)equalityExpression.leftOperand()).secondary((Tree)equalityExpression.rightOperand()));
    }

    private static class EqualityVisitor
    extends SubscriptionVisitor {
        Set<BinaryExpressionTree> equalityExpressions = new HashSet<BinaryExpressionTree>();

        private EqualityVisitor() {
        }

        public List<Tree.Kind> nodesToVisit() {
            return Lists.newArrayList((Object[])EQUALITY_KINDS);
        }

        public void visitNode(Tree tree) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
            if (!EqualityVisitor.isNullLiteral(binaryExpressionTree.leftOperand()) && !EqualityVisitor.isNullLiteral(binaryExpressionTree.rightOperand())) {
                this.equalityExpressions.add(binaryExpressionTree);
            }
        }

        private static boolean isNullLiteral(ExpressionTree expressionTree) {
            return expressionTree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }
    }
}

