/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S2990")
public class GlobalThisCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove the use of \"this\".";
    private int scopeLevel = 0;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().addAll((Iterable)TreeKinds.functionKinds()).add((Object)Tree.Kind.DOT_MEMBER_EXPRESSION).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            ExpressionTree object = ((MemberExpressionTree)tree).object();
            if (object.is(new Tree.Kind[]{Tree.Kind.THIS}) && this.scopeLevel == 0) {
                this.addIssue((Tree)object, MESSAGE);
            }
            return;
        }
        ++this.scopeLevel;
    }

    public void leaveNode(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            --this.scopeLevel;
        }
    }
}

