/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

@Rule(key="S3759")
public class NonExistentPropertyAccessCheck
extends SeCheck {
    private static final String MESSAGE = "Remove this access to \"%s\" property, it doesn't exist, as a built-in, on a %s.";
    private static final Map<Type, String> TYPE_NAMES = ImmutableMap.builder().put((Object)Type.NUMBER_PRIMITIVE, (Object)"Number").put((Object)Type.NUMBER_OBJECT, (Object)"Number").put((Object)Type.STRING_PRIMITIVE, (Object)"String").put((Object)Type.STRING_OBJECT, (Object)"String").put((Object)Type.BOOLEAN_PRIMITIVE, (Object)"Boolean").put((Object)Type.BOOLEAN_OBJECT, (Object)"Boolean").build();
    private final Set<Tree> treesWithIssues = new HashSet<Tree>();
    private ProgramState programStateBefore = null;

    public void startOfExecution(Scope functionScope) {
        this.treesWithIssues.clear();
    }

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        this.programStateBefore = currentState;
    }

    public void afterBlockElement(ProgramState currentState, Tree element) {
        IdentifierTree propertyTree;
        if (NonExistentPropertyAccessCheck.isUndefinedProperty(currentState, element) && !NonExistentPropertyAccessCheck.isWrite(element) && !NonExistentPropertyAccessCheck.isInCondition(element) && !this.treesWithIssues.contains(propertyTree = ((DotMemberExpressionTree)element).property())) {
            this.addIssue(element, String.format(MESSAGE, propertyTree.name(), NonExistentPropertyAccessCheck.getTypeOfObject(this.programStateBefore)));
            this.treesWithIssues.add((Tree)propertyTree);
        }
    }

    private static String getTypeOfObject(ProgramState programState) {
        Constraint constraintOnObject = programState.getConstraint(programState.peekStack());
        Type type = Type.find((Constraint)constraintOnObject);
        Preconditions.checkState((type != null && TYPE_NAMES.containsKey(type) ? 1 : 0) != 0);
        return TYPE_NAMES.get(type);
    }

    private static boolean isUndefinedProperty(ProgramState currentState, Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && SpecialSymbolicValue.UNDEFINED.equals((Object)currentState.peekStack());
    }

    private static boolean isWrite(Tree element) {
        Tree parentTree = ((JavaScriptTree)element).getParent();
        return parentTree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && !((AssignmentExpressionTree)parentTree).expression().equals(element);
    }

    private static boolean isInCondition(Tree element) {
        Tree parentTree = ((JavaScriptTree)element).getParent();
        return parentTree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.CONDITIONAL_EXPRESSION});
    }
}

