/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2814")
public class RedeclaredSymbolCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Rename \"%s\" as this name is already used in declaration at line %s.";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        Set symbols = symbolModel.getSymbols();
        for (Symbol symbol : symbols) {
            this.visitSymbol(symbol);
        }
    }

    private void visitSymbol(Symbol symbol) {
        Usage firstDeclaration = null;
        for (Usage usage : symbol.usages()) {
            if (firstDeclaration == null) {
                if (!usage.isDeclaration() && usage.kind() != Usage.Kind.LEXICAL_DECLARATION) continue;
                firstDeclaration = usage;
                continue;
            }
            if (!usage.isDeclaration()) continue;
            String message = String.format(MESSAGE, symbol.name(), ((JavaScriptTree)firstDeclaration.identifierTree()).getLine());
            this.addIssue((Tree)usage.identifierTree(), message).secondary((Tree)firstDeclaration.identifierTree());
        }
    }
}

