/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Objects;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="TooManyBreakOrContinueInLoop")
public class TooManyBreakOrContinueInLoopCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Reduce the total number of \"break\" and \"continue\" statements in this loop to use one at most.";
    private Deque<JumpTarget> jumpTargets = new ArrayDeque<JumpTarget>();

    public void visitScript(ScriptTree tree) {
        this.jumpTargets.clear();
        super.visitScript(tree);
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        this.increaseNumberOfJumpInScopes(tree.breakKeyword(), tree.label());
        super.visitBreakStatement(tree);
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        this.increaseNumberOfJumpInScopes(tree.continueKeyword(), tree.label());
        super.visitContinueStatement(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.enterScope();
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.enterScope();
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.enterScope();
        super.visitSwitchStatement(tree);
        this.leaveScope();
    }

    public void visitForStatement(ForStatementTree tree) {
        this.enterScope();
        super.visitForStatement(tree);
        this.leaveScopeAndCheckNumberOfJump(tree.forKeyword());
    }

    public void visitForObjectStatement(ForObjectStatementTree tree) {
        this.enterScope();
        super.visitForObjectStatement(tree);
        this.leaveScopeAndCheckNumberOfJump(tree.forKeyword());
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.enterScope();
        super.visitWhileStatement(tree);
        this.leaveScopeAndCheckNumberOfJump(tree.whileKeyword());
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.enterScope();
        super.visitDoWhileStatement(tree);
        this.leaveScopeAndCheckNumberOfJump(tree.doKeyword());
    }

    public void visitLabelledStatement(LabelledStatementTree tree) {
        this.jumpTargets.push(new JumpTarget(tree.label().name()));
        super.visitLabelledStatement(tree);
        this.leaveScope();
    }

    private void enterScope() {
        this.jumpTargets.push(new JumpTarget());
    }

    private void leaveScope() {
        this.jumpTargets.pop();
    }

    private void increaseNumberOfJumpInScopes(SyntaxToken jump, @Nullable IdentifierTree label) {
        for (JumpTarget jumpTarget : this.jumpTargets) {
            String labelName = label == null ? null : label.name();
            jumpTarget.jumps.add(jump);
            if (!Objects.equal((Object)labelName, (Object)jumpTarget.label)) continue;
            break;
        }
    }

    private void leaveScopeAndCheckNumberOfJump(SyntaxToken loopKeyword) {
        List jumps = this.jumpTargets.pop().jumps;
        int jumpStatementNumber = jumps.size();
        if (jumpStatementNumber > 1) {
            PreciseIssue issue = this.addIssue((Tree)loopKeyword, MESSAGE).cost((double)jumpStatementNumber - 1.0);
            for (Tree jump : jumps) {
                issue.secondary(new IssueLocation(jump));
            }
        }
    }

    private static class JumpTarget {
        private final String label;
        private List<Tree> jumps = new ArrayList<Tree>();

        public JumpTarget() {
            this.label = null;
        }

        public JumpTarget(String label) {
            this.label = label;
        }
    }
}

