/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="TrailingComment")
public class TrailingCommentCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Move this trailing comment on the previous empty line.";
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^//\\s*+[^\\s]++$";
    @RuleProperty(key="legalCommentPattern", description="Pattern for text of trailing comments that are allowed.", defaultValue="^//\\s*+[^\\s]++$")
    private String legalCommentPattern = "^//\\s*+[^\\s]++$";
    private Pattern pattern;
    private int previousTokenLine;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitFile(Tree tree) {
        this.previousTokenLine = -1;
        this.pattern = Pattern.compile(this.legalCommentPattern);
    }

    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            String comment;
            if (trivia.line() != this.previousTokenLine || !(comment = trivia.text()).startsWith("//") || this.pattern.matcher(comment).matches()) continue;
            this.addIssue((Tree)trivia, MESSAGE);
        }
        this.previousTokenLine = token.line();
    }

    public void setLegalCommentPattern(String pattern) {
        this.legalCommentPattern = pattern;
    }
}

