/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAllPathSeCheck;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.FunctionWithTreeSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

@Rule(key="S3699")
public class UseOfEmptyReturnValueCheck
extends AbstractAllPathSeCheck<CallExpressionTree> {
    private static final String MESSAGE = "Remove this use of the output from %s; %s doesn't return anything.";

    @Override
    CallExpressionTree getTree(Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION})) {
            return (CallExpressionTree)element;
        }
        return null;
    }

    @Override
    boolean isProblem(CallExpressionTree tree, ProgramState currentState) {
        FunctionTree functionTree = UseOfEmptyReturnValueCheck.functionTree(tree, currentState);
        return functionTree != null && !UseOfEmptyReturnValueCheck.hasReturnValue(functionTree) && UseOfEmptyReturnValueCheck.isReturnValueUsed(tree);
    }

    private static boolean hasReturnValue(FunctionTree functionTree) {
        return ReturnVisitor.hasReturnValue(functionTree);
    }

    private static boolean isReturnValueUsed(CallExpressionTree tree) {
        Tree parent = UseOfEmptyReturnValueCheck.getParentIgnoreParenthesis((Tree)tree);
        if (parent.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR, Tree.Kind.CONDITIONAL_AND})) {
            return ((BinaryExpressionTree)parent).leftOperand().equals(tree);
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            return ((ConditionalExpressionTree)parent).condition().equals(tree);
        }
        return !parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    @CheckForNull
    private static FunctionTree functionTree(CallExpressionTree tree, ProgramState currentState) {
        SymbolicValue calleeSV = currentState.peekStack(tree.arguments().parameters().size());
        if (calleeSV instanceof FunctionWithTreeSymbolicValue) {
            return ((FunctionWithTreeSymbolicValue)calleeSV).getFunctionTree();
        }
        return null;
    }

    @Override
    void raiseIssue(CallExpressionTree tree) {
        String functionName = "this function";
        if (tree.callee().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            functionName = "\"" + ((IdentifierTree)tree.callee()).name() + "\"";
        }
        this.addIssue((Tree)tree.callee(), String.format(MESSAGE, functionName, functionName));
    }

    private static Tree getParentIgnoreParenthesis(Tree tree) {
        Tree parent = ((JavaScriptTree)tree).getParent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            return UseOfEmptyReturnValueCheck.getParentIgnoreParenthesis(parent);
        }
        return parent;
    }

    private static class ReturnVisitor
    extends SubscriptionVisitor {
        boolean hasReturnValue = false;
        int nestingLevel = 0;

        private ReturnVisitor() {
        }

        public List<Tree.Kind> nodesToVisit() {
            return ImmutableList.builder().addAll((Iterable)TreeKinds.functionKinds()).add((Object)Tree.Kind.RETURN_STATEMENT).build();
        }

        private static boolean hasReturnValue(FunctionTree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.ARROW_FUNCTION})) {
                ArrowFunctionTree arrowFunction = (ArrowFunctionTree)tree;
                if (!arrowFunction.body().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                    return true;
                }
            }
            ReturnVisitor returnVisitor = new ReturnVisitor();
            returnVisitor.scanTree(tree.body());
            return returnVisitor.hasReturnValue;
        }

        public void visitNode(Tree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
                ReturnStatementTree returnStatement = (ReturnStatementTree)tree;
                if (returnStatement.expression() != null && this.nestingLevel == 0) {
                    this.hasReturnValue = true;
                }
            } else {
                ++this.nestingLevel;
            }
        }

        public void leaveNode(Tree tree) {
            if (!tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
                --this.nestingLevel;
            }
        }
    }
}

