/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S905")
public class UselessExpressionStatementCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Refactor or remove this statement.";

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        Tree expression = tree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && !UselessExpressionStatementCheck.isUseStrictDirective((LiteralTree)expression)) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitExpressionStatement(tree);
    }

    private static boolean isUseStrictDirective(LiteralTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String value = tree.value();
            value = value.substring(1, value.length() - 1);
            return "use strict".equals(value);
        }
        return false;
    }
}

