/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashMap;
import java.util.Map;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;

abstract class AbstractAllPathSeCheck<T extends Tree>
extends SeCheck {
    private Map<T, Boolean> problemMap = new HashMap<T, Boolean>();

    AbstractAllPathSeCheck() {
    }

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        T tree = this.getTree(element);
        if (tree != null) {
            boolean isProblem = this.isProblem(tree, currentState);
            if (!isProblem) {
                this.problemMap.put(tree, false);
            } else if (!this.problemMap.containsKey(tree)) {
                this.problemMap.put(tree, true);
            }
        }
    }

    abstract T getTree(Tree var1);

    abstract boolean isProblem(T var1, ProgramState var2);

    public void startOfExecution(Scope functionScope) {
        this.problemMap.clear();
    }

    public void endOfExecution(Scope functionScope) {
        for (Map.Entry<T, Boolean> entry : this.problemMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            this.raiseIssue((Tree)entry.getKey());
        }
    }

    abstract void raiseIssue(T var1);
}

