/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.builtins.BuiltInObjectSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;

@Rule(key="S3796")
public class ArrayCallbackWithoutReturnCheck
extends AbstractAnyPathSeCheck {
    private static final String MESSAGE = "Add a \"return\" statement to this callback.";
    private static final Set<String> METHODS_WITH_CALLBACK = ImmutableSet.of((Object)"every", (Object)"filter", (Object)"find", (Object)"findIndex", (Object)"map", (Object)"reduce", (Object[])new String[]{"reduceRight", "some", "sort"});

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree memberExpression = (DotMemberExpressionTree)element;
            if (ArrayCallbackWithoutReturnCheck.isArrayPropertyExecuted(currentState) && METHODS_WITH_CALLBACK.contains(memberExpression.property().name())) {
                this.checkArgumentToBeFunctionWithReturn(memberExpression, 0);
            } else if (ArrayCallbackWithoutReturnCheck.isArrayFromMethod(memberExpression, currentState)) {
                this.checkArgumentToBeFunctionWithReturn(memberExpression, 1);
            }
        }
    }

    private void checkArgumentToBeFunctionWithReturn(DotMemberExpressionTree callee, int argumentIndex) {
        Tree secondArgument;
        CallExpressionTree callExpressionTree;
        Tree parent = ((JavaScriptTree)callee).getParent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION}) && (callExpressionTree = (CallExpressionTree)parent).arguments().parameters().size() > argumentIndex && (secondArgument = (Tree)callExpressionTree.arguments().parameters().get(argumentIndex)).is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION}) && !ArrayCallbackWithoutReturnCheck.hasReturnWithValue((FunctionTree)secondArgument)) {
            this.raiseIssue(secondArgument);
        }
    }

    private void raiseIssue(Tree firstArgument) {
        SyntaxToken tokenToRaiseIssue = firstArgument.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION}) ? ((FunctionExpressionTree)firstArgument).functionKeyword() : ((ArrowFunctionTree)firstArgument).doubleArrow();
        this.addUniqueIssue((Tree)tokenToRaiseIssue, MESSAGE);
    }

    private static boolean hasReturnWithValue(FunctionTree functionTree) {
        if (functionTree.body().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            ControlFlowGraph cfg = ControlFlowGraph.build((BlockTree)((BlockTree)functionTree.body()));
            for (CfgBlock cfgBlock : cfg.blocks()) {
                if (cfgBlock.elements().isEmpty()) continue;
                Tree lastElement = (Tree)cfgBlock.elements().get(cfgBlock.elements().size() - 1);
                if (!lastElement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) || ((ReturnStatementTree)lastElement).expression() == null) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isArrayPropertyExecuted(ProgramState currentState) {
        SymbolicValue symbolicValue = currentState.peekStack();
        Constraint constraint = currentState.getConstraint(symbolicValue);
        return constraint.isStricterOrEqualTo(Constraint.ARRAY);
    }

    private static boolean isArrayFromMethod(DotMemberExpressionTree memberExpression, ProgramState currentState) {
        SymbolicValue symbolicValue = currentState.peekStack();
        return symbolicValue.equals(BuiltInObjectSymbolicValue.ARRAY) && "from".equals(memberExpression.property().name());
    }
}

