/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3801")
public class ConsistentReturnsCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Refactor this function to use \"return\" consistently.";

    public List<Tree.Kind> nodesToVisit() {
        return TreeKinds.functionKinds();
    }

    public void visitNode(Tree tree) {
        FunctionTree functionTree = (FunctionTree)tree;
        if (functionTree.body().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree body = (BlockTree)functionTree.body();
            FunctionReturns functionReturns = ConsistentReturnsCheck.getFunctionReturns(body);
            if (functionReturns.containsReturnWithoutValue && functionReturns.containsReturnWithValue) {
                this.raiseIssue(tree, functionReturns, body);
            }
        }
    }

    private void raiseIssue(Tree functionTree, FunctionReturns functionReturns, BlockTree body) {
        SyntaxToken tokenToRaiseIssue = ((JavaScriptTree)functionTree).getFirstToken();
        if (functionTree.is(new Tree.Kind[]{Tree.Kind.ARROW_FUNCTION})) {
            tokenToRaiseIssue = ((ArrowFunctionTree)functionTree).doubleArrow();
        }
        PreciseIssue issue = this.addIssue((Tree)tokenToRaiseIssue, MESSAGE);
        for (ReturnStatementTree returnStatement : functionReturns.returnStatements) {
            issue.secondary((Tree)returnStatement.returnKeyword(), returnStatement.expression() == null ? "Return without value" : "Return with value");
        }
        if (functionReturns.containsImplicitReturn) {
            issue.secondary((Tree)body.closeCurlyBrace(), "Implicit return without value");
        }
    }

    private static FunctionReturns getFunctionReturns(BlockTree functionBody) {
        FunctionReturns functionReturns = new FunctionReturns();
        ControlFlowGraph cfg = ControlFlowGraph.build((BlockTree)functionBody);
        if (ConsistentReturnsCheck.containsTry(cfg)) {
            return functionReturns;
        }
        CfgBlock endBlock = cfg.end();
        for (CfgBlock cfgBlock : endBlock.predecessors()) {
            Tree lastElement = (Tree)cfgBlock.elements().get(cfgBlock.elements().size() - 1);
            if (lastElement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
                ReturnStatementTree returnStatement = (ReturnStatementTree)lastElement;
                if (returnStatement.expression() == null) {
                    functionReturns.containsReturnWithoutValue = true;
                } else {
                    functionReturns.containsReturnWithValue = true;
                }
                functionReturns.returnStatements.add(returnStatement);
                continue;
            }
            if (ConsistentReturnsCheck.isThrowStatement(lastElement) || !ConsistentReturnsCheck.isReachableBlock(cfgBlock, cfg)) continue;
            functionReturns.containsReturnWithoutValue = true;
            functionReturns.containsImplicitReturn = true;
        }
        return functionReturns;
    }

    private static boolean containsTry(ControlFlowGraph cfg) {
        for (CfgBlock cfgBlock : cfg.blocks()) {
            if (!(cfgBlock instanceof CfgBranchingBlock) || !((CfgBranchingBlock)cfgBlock).branchingTree().is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) continue;
            return true;
        }
        return false;
    }

    private static boolean isThrowStatement(Tree lastElement) {
        return ((JavaScriptTree)lastElement).getParent().is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT});
    }

    private static boolean isReachableBlock(CfgBlock cfgBlock, ControlFlowGraph cfg) {
        return !cfgBlock.predecessors().isEmpty() || cfgBlock.equals(cfg.start());
    }

    private static class FunctionReturns {
        boolean containsReturnWithValue = false;
        boolean containsReturnWithoutValue = false;
        boolean containsImplicitReturn = false;
        Set<ReturnStatementTree> returnStatements = new HashSet<ReturnStatementTree>();

        private FunctionReturns() {
        }
    }
}

