/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2228")
public class ConsoleLoggingCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this logging statement.";

    public void visitCallExpression(CallExpressionTree tree) {
        DotMemberExpressionTree callee;
        if (tree.callee().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && ConsoleLoggingCheck.isCalleeConsoleLogging(callee = (DotMemberExpressionTree)tree.callee())) {
            this.addIssue((Tree)callee, MESSAGE);
        }
        super.visitCallExpression(tree);
    }

    private static boolean isCalleeConsoleLogging(DotMemberExpressionTree callee) {
        return callee.object().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "console".equals(((IdentifierTree)callee.object()).name()) && "log".equals(callee.property().name());
    }
}

