/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.ModuleTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.BracketMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.DefaultClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S3514")
public class DestructuringAssignmentSyntaxCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use destructuring syntax for these assignments from \"%s\".";
    private static final Set<String> ALLOWED_INDEXES = ImmutableSet.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4");

    public void visitBlock(BlockTree tree) {
        this.visitStatements(tree.statements());
        super.visitBlock(tree);
    }

    public void visitCaseClause(CaseClauseTree tree) {
        this.visitStatements(tree.statements());
        super.visitCaseClause(tree);
    }

    public void visitDefaultClause(DefaultClauseTree tree) {
        this.visitStatements(tree.statements());
        super.visitDefaultClause(tree);
    }

    public void visitModule(ModuleTree tree) {
        this.visitStatements(tree.items());
        super.visitModule(tree);
    }

    private void visitStatements(List<? extends Tree> statements) {
        ArrayListMultimap declarationsByObject = ArrayListMultimap.create();
        for (Tree tree : statements) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE_STATEMENT})) {
                VariableDeclarationTree declaration = ((VariableStatementTree)tree).declaration();
                DestructuringAssignmentSyntaxCheck.visitVariableDeclaration((ListMultimap<String, Declaration>)declarationsByObject, declaration);
                continue;
            }
            this.checkDeclarationsBlock((ListMultimap<String, Declaration>)declarationsByObject);
            declarationsByObject.clear();
        }
        this.checkDeclarationsBlock((ListMultimap<String, Declaration>)declarationsByObject);
    }

    private static void visitVariableDeclaration(ListMultimap<String, Declaration> declarationsByObject, VariableDeclarationTree declaration) {
        for (BindingElementTree bindingElement : declaration.variables()) {
            if (!bindingElement.is(new Tree.Kind[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) continue;
            InitializedBindingElementTree initializedDeclaration = (InitializedBindingElementTree)bindingElement;
            DestructuringAssignmentSyntaxCheck.visitInitializedDeclaration(declarationsByObject, declaration, initializedDeclaration);
        }
    }

    private static void visitInitializedDeclaration(ListMultimap<String, Declaration> declarationsByObject, VariableDeclarationTree declaration, InitializedBindingElementTree initializedDeclaration) {
        if (initializedDeclaration.left().is(new Tree.Kind[]{Tree.Kind.BINDING_IDENTIFIER})) {
            BracketMemberExpressionTree bracketMemberExpression;
            String varName = ((IdentifierTree)initializedDeclaration.left()).name();
            if (initializedDeclaration.right().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
                DotMemberExpressionTree dotMemberExpression = (DotMemberExpressionTree)initializedDeclaration.right();
                if (dotMemberExpression.property().name().equals(varName)) {
                    DestructuringAssignmentSyntaxCheck.addDeclaration(declarationsByObject, (MemberExpressionTree)dotMemberExpression, declaration, initializedDeclaration);
                }
            } else if (initializedDeclaration.right().is(new Tree.Kind[]{Tree.Kind.BRACKET_MEMBER_EXPRESSION}) && (bracketMemberExpression = (BracketMemberExpressionTree)initializedDeclaration.right()).property().is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && ALLOWED_INDEXES.contains(((LiteralTree)bracketMemberExpression.property()).value())) {
                DestructuringAssignmentSyntaxCheck.addDeclaration(declarationsByObject, (MemberExpressionTree)bracketMemberExpression, declaration, initializedDeclaration);
            }
        }
    }

    private static void addDeclaration(ListMultimap<String, Declaration> declarationsByObject, MemberExpressionTree memberExpression, VariableDeclarationTree declaration, InitializedBindingElementTree initializedBindingElement) {
        declarationsByObject.put((Object)CheckUtils.asString((Tree)memberExpression.object()), (Object)new Declaration(((JavaScriptTree)declaration).getKind(), initializedBindingElement));
    }

    private void checkDeclarationsBlock(ListMultimap<String, Declaration> declarationsByObject) {
        for (String objectName : declarationsByObject.keySet()) {
            List declarations = declarationsByObject.get((Object)objectName);
            if (declarations.size() <= 1 || !DestructuringAssignmentSyntaxCheck.sameDeclarationKind(declarations)) continue;
            PreciseIssue preciseIssue = this.addIssue((Tree)((Declaration)declarations.get((int)0)).tree, String.format(MESSAGE, objectName));
            for (int i = 1; i < declarations.size(); ++i) {
                preciseIssue.secondary((Tree)((Declaration)declarations.get((int)i)).tree);
            }
        }
    }

    private static boolean sameDeclarationKind(List<Declaration> declarations) {
        Tree.Kind firstKind = declarations.get((int)0).declarationKind;
        for (Declaration declaration : declarations) {
            if (declaration.declarationKind == firstKind) continue;
            return false;
        }
        return true;
    }

    private static class Declaration {
        Tree.Kind declarationKind;
        InitializedBindingElementTree tree;

        public Declaration(Tree.Kind declarationKind, InitializedBindingElementTree tree) {
            this.declarationKind = declarationKind;
            this.tree = tree;
        }
    }
}

