/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FieldDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="DuplicatePropertyName")
public class DuplicatePropertyNameCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Rename or remove duplicate property name '%s'.";

    public void visitObjectLiteral(ObjectLiteralTree tree) {
        this.checkProperties((List<Tree>)tree.properties());
        super.visitObjectLiteral(tree);
    }

    public void visitClass(ClassTree tree) {
        this.checkProperties(tree.elements());
        super.visitClass(tree);
    }

    private void checkProperties(List<Tree> properties) {
        LinkedListMultimap keys = LinkedListMultimap.create();
        for (Tree property : properties) {
            String propertyName;
            Tree propertyNameTree = DuplicatePropertyNameCheck.getPropertyNameTree(property);
            if (propertyNameTree == null || (propertyName = DuplicatePropertyNameCheck.getPropertyName(propertyNameTree)) == null) continue;
            keys.put((Object)EscapeUtils.unescape(propertyName), (Object)property);
        }
        this.checkKeys((ListMultimap<String, Tree>)keys);
    }

    private void checkKeys(ListMultimap<String, Tree> keys) {
        for (String key : keys.keySet()) {
            List properties = keys.get((Object)key);
            if (properties.size() <= 1 || DuplicatePropertyNameCheck.getterSetter(properties)) continue;
            Tree duplicatedProperty = DuplicatePropertyNameCheck.getPropertyNameTree((Tree)properties.remove(0));
            for (Tree property : properties) {
                Tree propertyKey = DuplicatePropertyNameCheck.getPropertyNameTree(property);
                this.addIssue(propertyKey, String.format(MESSAGE, DuplicatePropertyNameCheck.getPropertyName(propertyKey))).secondary(duplicatedProperty);
            }
        }
    }

    private static boolean getterSetter(List<Tree> value) {
        if (value.size() == 2) {
            return value.get(0).is(new Tree.Kind[]{Tree.Kind.GET_METHOD}) && value.get(1).is(new Tree.Kind[]{Tree.Kind.SET_METHOD}) || value.get(1).is(new Tree.Kind[]{Tree.Kind.GET_METHOD}) && value.get(0).is(new Tree.Kind[]{Tree.Kind.SET_METHOD});
        }
        return false;
    }

    @Nullable
    private static Tree getPropertyNameTree(Tree property) {
        if (property instanceof MethodDeclarationTree) {
            return ((MethodDeclarationTree)property).name();
        }
        if (property.is(new Tree.Kind[]{Tree.Kind.FIELD})) {
            return ((FieldDeclarationTree)property).propertyName();
        }
        if (property.is(new Tree.Kind[]{Tree.Kind.PAIR_PROPERTY})) {
            return ((PairPropertyTree)property).key();
        }
        if (property.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            return property;
        }
        return null;
    }

    @Nullable
    private static String getPropertyName(Tree propertyKey) {
        if (propertyKey.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String value = ((LiteralTree)propertyKey).value();
            return value.substring(1, value.length() - 1);
        }
        if (propertyKey.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_NAME, Tree.Kind.IDENTIFIER_REFERENCE})) {
            return ((IdentifierTree)propertyKey).name();
        }
        if (propertyKey.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL})) {
            return ((LiteralTree)propertyKey).value();
        }
        return null;
    }
}

