/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="ExcessiveParameterList")
public class ExcessiveParameterListCheck
extends DoubleDispatchVisitorCheck {
    private static final int DEFAULT_MAXIMUM_FUNCTION_PARAMETERS = 7;
    @RuleProperty(key="maximumFunctionParameters", description="The maximum authorized number of parameters", defaultValue="7")
    private int maximumFunctionParameters = 7;

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkNumberOfParameters(tree.parameterClause());
        super.visitMethodDeclaration(tree);
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkNumberOfParameters(tree.parameterClause());
        super.visitFunctionDeclaration(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkNumberOfParameters(tree.parameterClause());
        super.visitFunctionExpression(tree);
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        Tree parameterClause = tree.parameterClause();
        if (parameterClause.is(new Tree.Kind[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            this.checkNumberOfParameters((ParameterListTree)parameterClause);
        }
        super.visitArrowFunction(tree);
    }

    private void checkNumberOfParameters(ParameterListTree tree) {
        Integer numberOfParameters = tree.parameters().size();
        if (numberOfParameters > this.maximumFunctionParameters) {
            this.addIssue((Tree)tree, "Function has " + numberOfParameters + " parameters which is greater than " + this.maximumFunctionParameters + " authorized.");
        }
    }

    public void setMaximumFunctionParameters(int threshold) {
        this.maximumFunctionParameters = threshold;
    }
}

