/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S3800")
public class FunctionReturnTypeCheck
extends SeCheck {
    private static final String MESSAGE = "Refactor this function to always return the same type.";
    private static final Map<Constraint, String> TYPES = ImmutableMap.builder().put((Object)Constraint.STRING_PRIMITIVE, (Object)"String").put((Object)Constraint.NUMBER_PRIMITIVE, (Object)"Number").put((Object)Constraint.BOOLEAN_PRIMITIVE, (Object)"Boolean").put((Object)Constraint.FUNCTION, (Object)"Function").put((Object)Constraint.REGEXP, (Object)"RegExp").put((Object)Constraint.ARRAY, (Object)"Array").put((Object)Constraint.DATE, (Object)"Date").put((Object)Constraint.OTHER_OBJECT, (Object)"Object").build();
    private static final Constraint UNKNOWN_TYPE = Constraint.ANY_VALUE;
    private Multimap<ReturnStatementTree, Constraint> returnedValueConstraintsByReturnStatement = ArrayListMultimap.create();

    public void startOfExecution(Scope functionScope) {
        this.returnedValueConstraintsByReturnStatement.clear();
    }

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        SymbolicValue symbolicValue;
        Constraint typeConstraint;
        ReturnStatementTree returnStatement;
        if (element.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) && (returnStatement = (ReturnStatementTree)element).expression() != null && !UNKNOWN_TYPE.equals((Object)(typeConstraint = FunctionReturnTypeCheck.toTypeConstraint(currentState.getConstraint(symbolicValue = currentState.peekStack()))))) {
            this.returnedValueConstraintsByReturnStatement.put((Object)returnStatement, (Object)typeConstraint);
        }
    }

    private static Constraint toTypeConstraint(Constraint constraint) {
        for (Constraint typeConstraint : TYPES.keySet()) {
            if (!constraint.isStricterOrEqualTo(typeConstraint)) continue;
            return typeConstraint;
        }
        return UNKNOWN_TYPE;
    }

    public void endOfExecution(Scope functionScope) {
        HashSet returnedTypes = new HashSet(this.returnedValueConstraintsByReturnStatement.values());
        if (returnedTypes.size() > 1) {
            this.raiseIssue(functionScope.tree());
        }
    }

    private void raiseIssue(Tree functionTree) {
        SyntaxToken firstFunctionToken = ((JavaScriptTree)functionTree).getFirstToken();
        PreciseIssue issue = this.addIssue((Tree)firstFunctionToken, MESSAGE);
        for (ReturnStatementTree returnStatement : this.returnedValueConstraintsByReturnStatement.keySet()) {
            HashSet returnedTypes = new HashSet(this.returnedValueConstraintsByReturnStatement.get((Object)returnStatement));
            if (returnedTypes.isEmpty()) continue;
            List typeNames = returnedTypes.stream().map(TYPES::get).collect(Collectors.toList());
            Collections.sort(typeNames);
            String typesForSecondaryMessage = String.join((CharSequence)" or ", typeNames);
            issue.secondary((Tree)returnStatement.returnKeyword(), "Returns " + typesForSecondaryMessage);
        }
    }
}

