/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S2376")
public class GetterSetterCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Provide a %s matching this %s for '%s'.";

    public void visitObjectLiteral(ObjectLiteralTree tree) {
        this.checkProperties((List<Tree>)tree.properties());
        super.visitObjectLiteral(tree);
    }

    public void visitClass(ClassTree tree) {
        this.checkProperties(tree.elements());
        super.visitClass(tree);
    }

    private void checkProperties(List<Tree> properties) {
        Map<String, AccessorMethodDeclarationTree> getters = GetterSetterCheck.accessors(Tree.Kind.GET_METHOD, properties);
        Map<String, AccessorMethodDeclarationTree> setters = GetterSetterCheck.accessors(Tree.Kind.SET_METHOD, properties);
        Set<String> getterNames = getters.keySet();
        Set<String> setterNames = setters.keySet();
        Sets.SetView onlyGetters = Sets.difference(getterNames, setterNames);
        Sets.SetView onlySetters = Sets.difference(setterNames, getterNames);
        for (String getterName : onlyGetters) {
            this.raiseIssue(getters.get(getterName), String.format(MESSAGE, "setter", "getter", getterName));
        }
        for (String setterName : onlySetters) {
            this.raiseIssue(setters.get(setterName), String.format(MESSAGE, "getter", "setter", setterName));
        }
    }

    private void raiseIssue(AccessorMethodDeclarationTree tree, String message) {
        this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, new IssueLocation((Tree)tree, tree.name(), message)));
    }

    private static Map<String, AccessorMethodDeclarationTree> accessors(Tree.Kind kind, List<Tree> properties) {
        return properties.stream().filter(property -> property.is(new Tree.Kind[]{kind})).collect(Collectors.toMap(property -> GetterSetterCheck.getName((AccessorMethodDeclarationTree)property), tree -> (AccessorMethodDeclarationTree)tree));
    }

    private static String getName(AccessorMethodDeclarationTree tree) {
        return CheckUtils.asString(tree.name());
    }
}

