/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S881")
public class IncrementDecrementInSubExpressionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Extract this %s operation into a dedicated statement.";

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        if (TreeKinds.isIncrementOrDecrement((Tree)tree.expression())) {
            this.scan((Tree)((UnaryExpressionTree)tree.expression()).expression());
        } else {
            this.scan(tree.expression());
        }
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (TreeKinds.isIncrementOrDecrement((Tree)tree)) {
            this.raiseIssue(tree);
        }
        super.visitUnaryExpression(tree);
    }

    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.init());
        this.scan((Tree)tree.condition());
        this.scanUpdateClause(tree.update());
        this.scan((Tree)tree.statement());
    }

    private void scanUpdateClause(@Nullable ExpressionTree tree) {
        if (tree != null) {
            if (TreeKinds.isIncrementOrDecrement((Tree)tree)) {
                this.scan((Tree)((UnaryExpressionTree)tree).expression());
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
                BinaryExpressionTree expressionList = (BinaryExpressionTree)tree;
                this.scanUpdateClause(expressionList.leftOperand());
                this.scanUpdateClause(expressionList.rightOperand());
            } else {
                this.scan((Tree)tree);
            }
        }
    }

    private void raiseIssue(UnaryExpressionTree tree) {
        String message = String.format(MESSAGE, "++".equals(tree.operator().text()) ? "increment" : "decrement");
        this.addIssue((Tree)tree.operator(), message);
    }
}

