/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3812")
public class InstanceofInMisuseCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Add parentheses to perform \"%s\" operator before logical NOT operator.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INSTANCE_OF, (Object)Tree.Kind.RELATIONAL_IN);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree expression = (BinaryExpressionTree)tree;
        if (expression.leftOperand().is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            this.addIssue(tree, String.format(MESSAGE, expression.operator().text()));
        }
    }
}

