/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.EnumSet;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1143")
public class JumpStatementInFinallyCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this \"%s\" statement from this \"finally\" block.";
    private static final EnumSet<Tree.Kind> SAFE_PARENTS_FOR_RETURN = EnumSet.of(Tree.Kind.SCRIPT, Tree.Kind.TRY_STATEMENT, Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION);
    private static final EnumSet<Tree.Kind> SAFE_PARENTS_FOR_CONTINUE;
    private static final EnumSet<Tree.Kind> SAFE_PARENTS_FOR_BREAK;

    public void visitReturnStatement(ReturnStatementTree tree) {
        this.check((StatementTree)tree, tree.returnKeyword(), SAFE_PARENTS_FOR_RETURN);
        super.visitReturnStatement(tree);
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        this.check((StatementTree)tree, tree.continueKeyword(), SAFE_PARENTS_FOR_CONTINUE);
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        EnumSet<Tree.Kind> safeParents = tree.label() == null ? SAFE_PARENTS_FOR_BREAK : SAFE_PARENTS_FOR_RETURN;
        this.check((StatementTree)tree, tree.breakKeyword(), safeParents);
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        this.check((StatementTree)tree, tree.throwKeyword(), SAFE_PARENTS_FOR_RETURN);
        super.visitThrowStatement(tree);
    }

    private void check(StatementTree jumpStatement, SyntaxToken token, EnumSet<Tree.Kind> safeParents) {
        Tree parent = JumpStatementInFinallyCheck.parent((Tree)jumpStatement);
        while (!safeParents.contains(((JavaScriptTree)parent).getKind())) {
            SyntaxToken finallyKeyword = JumpStatementInFinallyCheck.getFinallyKeywordForFinallyBlock(parent);
            if (finallyKeyword != null) {
                this.addIssue((Tree)token, String.format(MESSAGE, token.text())).secondary((Tree)finallyKeyword);
                return;
            }
            parent = JumpStatementInFinallyCheck.parent(parent);
        }
    }

    private static Tree parent(Tree tree) {
        return ((JavaScriptTree)tree).getParent();
    }

    @CheckForNull
    private static SyntaxToken getFinallyKeywordForFinallyBlock(Tree tree) {
        TryStatementTree tryStatementTree;
        Tree parent;
        if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK}) && (parent = JumpStatementInFinallyCheck.parent(tree)).is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT}) && tree.equals((tryStatementTree = (TryStatementTree)parent).finallyBlock())) {
            return tryStatementTree.finallyKeyword();
        }
        return null;
    }

    static {
        SAFE_PARENTS_FOR_RETURN.addAll(TreeKinds.functionKinds());
        SAFE_PARENTS_FOR_CONTINUE = EnumSet.of(Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT);
        SAFE_PARENTS_FOR_CONTINUE.addAll(SAFE_PARENTS_FOR_RETURN);
        SAFE_PARENTS_FOR_BREAK = EnumSet.of(Tree.Kind.SWITCH_STATEMENT);
        SAFE_PARENTS_FOR_BREAK.addAll(SAFE_PARENTS_FOR_CONTINUE);
    }
}

