/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2999")
public class NewOperatorMisuseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Replace %s with a constructor function.";
    public static final boolean CONSIDER_JSDOC = false;
    @RuleProperty(key="considerJSDoc", description="Consider only functions with @constructor tag as constructor functions", defaultValue="false")
    public boolean considerJSDoc = false;

    public void visitNewExpression(NewExpressionTree tree) {
        ExpressionTree expression = tree.expression();
        if (!expression.types().isEmpty() && !this.isConstructor(expression.types())) {
            ExpressionTree primaryLocationTree = expression;
            String expressionStr = CheckUtils.asString((Tree)expression);
            ExpressionTree unwrapped = CheckUtils.removeParenthesis(expression);
            if (unwrapped.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION})) {
                primaryLocationTree = ((FunctionExpressionTree)unwrapped).functionKeyword();
                expressionStr = "this function";
            }
            this.addIssue((Tree)primaryLocationTree, String.format(MESSAGE, expressionStr)).secondary((Tree)tree.newKeyword());
        }
        super.visitNewExpression(tree);
    }

    private boolean isConstructor(TypeSet types) {
        boolean isConstructor = true;
        Type type = types.getUniqueKnownType();
        if (type != null && type.kind() != Type.Kind.CLASS) {
            if (type.callability().equals((Object)Type.Callability.NON_CALLABLE)) {
                isConstructor = false;
            } else if (this.considerJSDoc && type.kind().equals((Object)Type.Kind.FUNCTION)) {
                isConstructor = NewOperatorMisuseCheck.hasJSDocAnnotation(((FunctionType)type).functionTree());
            }
        }
        return isConstructor;
    }

    private static boolean hasJSDocAnnotation(FunctionTree funcDec) {
        for (SyntaxTrivia trivia : ((JavaScriptTree)funcDec).getFirstToken().trivias()) {
            if (!trivia.text().contains("@constructor") && !trivia.text().contains("@class")) continue;
            return true;
        }
        return false;
    }
}

