/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S1219")
public class NonCaseLabelInSwitchCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove this misleading \"%s\" label.";
    private Deque<Integer> stack = new ArrayDeque<Integer>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object[])new Tree.Kind[]{Tree.Kind.LABELLED_STATEMENT, Tree.Kind.CASE_CLAUSE}).add((Object[])new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION}).build();
    }

    public void visitFile(Tree scriptTree) {
        this.stack.clear();
        this.stack.push(0);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE})) {
            this.enterCase();
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.LABELLED_STATEMENT})) {
            if (this.inCase()) {
                IdentifierTree label = ((LabelledStatementTree)tree).label();
                this.addIssue((Tree)label, String.format(MESSAGE, label.name()));
            }
        } else {
            this.stack.push(0);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE})) {
            this.leaveCase();
        } else if (!tree.is(new Tree.Kind[]{Tree.Kind.LABELLED_STATEMENT})) {
            this.stack.pop();
        }
    }

    private void leaveCase() {
        this.stack.push(this.stack.pop() - 1);
    }

    private boolean inCase() {
        return this.stack.peek() > 0;
    }

    private void enterCase() {
        this.stack.push(this.stack.pop() + 1);
    }
}

