/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.EnumSet;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

@Rule(key="S3760")
public class NonNumberInArithmeticExpressionCheck
extends AbstractAnyPathSeCheck {
    private static final String MESSAGE = "Convert this operand into a number.";
    private static final Tree.Kind[] UNARY_KINDS = new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT};
    private static final Tree.Kind[] PLUS_KINDS = new Tree.Kind[]{Tree.Kind.PLUS, Tree.Kind.PLUS_ASSIGNMENT};
    private static final Tree.Kind[] COMPARISON_KINDS = new Tree.Kind[]{Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO};
    private static final Tree.Kind[] ARITHMETIC_KINDS = new Tree.Kind[]{Tree.Kind.MINUS, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT};
    private static final EnumSet<Type> BOOLEAN_STRING_DATE = EnumSet.of(Type.BOOLEAN_PRIMITIVE, Type.STRING_PRIMITIVE, Type.BOOLEAN_OBJECT, Type.STRING_OBJECT, Type.DATE);
    private static final EnumSet<Type> BOOLEAN_NUMBER = EnumSet.of(Type.BOOLEAN_PRIMITIVE, Type.NUMBER_PRIMITIVE, Type.BOOLEAN_OBJECT, Type.NUMBER_OBJECT);
    private static final EnumSet<Type> BOOLEAN_DATE = EnumSet.of(Type.BOOLEAN_PRIMITIVE, Type.BOOLEAN_OBJECT, Type.DATE);
    private static final EnumSet<Type> ANY_NUMBER = EnumSet.of(Type.NUMBER_PRIMITIVE, Type.NUMBER_OBJECT);

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        if (element.is(PLUS_KINDS) || element.is(COMPARISON_KINDS) || element.is(ARITHMETIC_KINDS)) {
            this.checkBinaryOperation(currentState, element);
        }
        if (element.is(UNARY_KINDS)) {
            Type operandType = currentState.getConstraint(currentState.peekStack()).type();
            ExpressionTree operand = ((UnaryExpressionTree)element).expression();
            if (BOOLEAN_STRING_DATE.contains(operandType)) {
                this.raiseIssue((Tree)operand, new Tree[]{((UnaryExpressionTree)element).operator()});
            }
        }
    }

    private void checkBinaryOperation(ProgramState currentState, Tree element) {
        SyntaxToken operator;
        ExpressionTree rightOperand;
        ExpressionTree leftOperand;
        Type rightType = currentState.getConstraint(currentState.peekStack(0)).type();
        Type leftType = currentState.getConstraint(currentState.peekStack(1)).type();
        if (element instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)element;
            leftOperand = assignment.variable();
            rightOperand = assignment.expression();
            operator = assignment.operator();
        } else {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)element;
            leftOperand = binaryExpression.leftOperand();
            rightOperand = binaryExpression.rightOperand();
            operator = binaryExpression.operator();
        }
        if (element.is(PLUS_KINDS)) {
            this.checkPlus(leftOperand, rightOperand, leftType, rightType, (Tree)operator);
        } else if (element.is(COMPARISON_KINDS)) {
            this.checkComparison(leftOperand, rightOperand, leftType, rightType, (Tree)operator);
        } else if (element.is(ARITHMETIC_KINDS)) {
            this.checkArithmetic(leftOperand, rightOperand, leftType, rightType, operator, element.is(new Tree.Kind[]{Tree.Kind.MINUS}));
        }
    }

    private void checkPlus(ExpressionTree leftOperand, ExpressionTree rightOperand, Type leftType, Type rightType, Tree operator) {
        if (ANY_NUMBER.contains(leftType) && BOOLEAN_DATE.contains(rightType)) {
            this.raiseIssue((Tree)rightOperand, new Tree[]{leftOperand, operator});
        }
        if (ANY_NUMBER.contains(rightType) && BOOLEAN_DATE.contains(leftType)) {
            this.raiseIssue((Tree)leftOperand, new Tree[]{rightOperand, operator});
        }
    }

    private void checkComparison(ExpressionTree leftOperand, ExpressionTree rightOperand, Type leftType, Type rightType, Tree operator) {
        if (BOOLEAN_NUMBER.contains(leftType) && BOOLEAN_STRING_DATE.contains(rightType)) {
            this.raiseIssue((Tree)rightOperand, new Tree[]{leftOperand, operator});
        }
        if (BOOLEAN_NUMBER.contains(rightType) && BOOLEAN_STRING_DATE.contains(leftType)) {
            this.raiseIssue((Tree)leftOperand, new Tree[]{rightOperand, operator});
        }
    }

    private void checkArithmetic(ExpressionTree leftOperand, ExpressionTree rightOperand, @Nullable Type leftType, @Nullable Type rightType, SyntaxToken operator, boolean isMinus) {
        if (NonNumberInArithmeticExpressionCheck.isDateMinusDateException(leftType, rightType, isMinus)) {
            return;
        }
        if (BOOLEAN_STRING_DATE.contains(leftType)) {
            this.raiseIssue((Tree)leftOperand, new Tree[]{rightOperand, operator});
        }
        if (BOOLEAN_STRING_DATE.contains(rightType)) {
            this.raiseIssue((Tree)rightOperand, new Tree[]{leftOperand, operator});
        }
    }

    private static boolean isDateMinusDateException(@Nullable Type leftType, @Nullable Type rightType, boolean isMinus) {
        if (isMinus) {
            if (leftType == Type.DATE && (rightType == Type.DATE || rightType == null)) {
                return true;
            }
            if (rightType == Type.DATE && leftType == null) {
                return true;
            }
        }
        return false;
    }

    private void raiseIssue(Tree tree, Tree ... secondaryLocations) {
        this.addUniqueIssue(tree, MESSAGE, secondaryLocations);
    }
}

