/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.symbols.type.Backbone;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2508")
public class SpaceInModelPropertyNameCheck
extends DoubleDispatchVisitorCheck {
    private static final String SET = "set";
    private static final String MESSAGE = "Rename this property to remove the spaces.";

    public void visitCallExpression(CallExpressionTree tree) {
        if (tree.types().contains(Type.Kind.BACKBONE_MODEL) && !tree.arguments().parameters().isEmpty()) {
            this.visitDefaults(tree);
        }
        if (tree.callee().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && SpaceInModelPropertyNameCheck.isBackboneSetMethod((DotMemberExpressionTree)tree.callee())) {
            this.visitSetMethodCall(tree);
        }
        super.visitCallExpression(tree);
    }

    private void visitSetMethodCall(CallExpressionTree tree) {
        Tree firstParameter = (Tree)tree.arguments().parameters().get(0);
        if (firstParameter.is(new Tree.Kind[]{Tree.Kind.OBJECT_LITERAL})) {
            this.checkForSpaceInPropertyNames((ObjectLiteralTree)firstParameter);
        }
        if (firstParameter.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.checkString((Tree)((ExpressionTree)firstParameter));
        }
    }

    private void visitDefaults(CallExpressionTree tree) {
        PairPropertyTree defaultsProp;
        Tree parameter = (Tree)tree.arguments().parameters().get(0);
        if (parameter.is(new Tree.Kind[]{Tree.Kind.OBJECT_LITERAL}) && (defaultsProp = Backbone.getModelProperty((ObjectLiteralTree)((ObjectLiteralTree)parameter), (String)"defaults")) != null && defaultsProp.value().is(new Tree.Kind[]{Tree.Kind.OBJECT_LITERAL})) {
            this.checkForSpaceInPropertyNames((ObjectLiteralTree)defaultsProp.value());
        }
    }

    private static boolean isBackboneSetMethod(DotMemberExpressionTree dotExpr) {
        return CheckUtils.asString((Tree)dotExpr.property()).equals(SET) && dotExpr.object().types().contains(Type.Kind.BACKBONE_MODEL_OBJECT);
    }

    private void checkForSpaceInPropertyNames(ObjectLiteralTree objectLiteral) {
        for (Tree attribute : objectLiteral.properties()) {
            if (!attribute.is(new Tree.Kind[]{Tree.Kind.PAIR_PROPERTY})) continue;
            Tree key = ((PairPropertyTree)attribute).key();
            this.checkString(key);
        }
    }

    private void checkString(Tree key) {
        if (key.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && StringUtils.contains((String)((LiteralTree)key).value(), (char)' ')) {
            this.addIssue(key, MESSAGE);
        }
    }
}

