/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.BuiltInFunctionSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;

@Rule(key="S930")
public class TooManyArgumentsCheck
extends AbstractAnyPathSeCheck {
    private static final String MESSAGE = "%s expects %s argument%s, but %s %s provided.";
    private static final Set<String> BUILT_IN_FUNCTIONS_TO_IGNORE = Sets.newHashSet((Object[])new String[]{"toString", "toLocaleString"});

    public void endOfFile(ScriptTree scriptTree) {
        TreeVisitorCheck visitor = new TreeVisitorCheck();
        visitor.visitScript(scriptTree);
    }

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION})) {
            BuiltInFunctionSymbolicValue builtInFunction;
            CallExpressionTree callExpression = (CallExpressionTree)element;
            SeparatedList actualArguments = callExpression.arguments().parameters();
            int nbActualArguments = actualArguments.size();
            SymbolicValue calleeValue = currentState.peekStack(nbActualArguments);
            if (nbActualArguments > 0 && calleeValue instanceof BuiltInFunctionSymbolicValue && this.shouldCheck(callExpression) && (builtInFunction = (BuiltInFunctionSymbolicValue)calleeValue).signature() != null && TooManyArgumentsCheck.hasTooManyArguments(builtInFunction.signature(), nbActualArguments)) {
                int nbExpectedArguments = TooManyArgumentsCheck.getNbParameters(builtInFunction.signature());
                String message = TooManyArgumentsCheck.getMessage(callExpression, nbExpectedArguments, nbActualArguments);
                this.addUniqueIssue((Tree)callExpression.arguments(), message);
            }
        }
    }

    private static boolean hasTooManyArguments(IntFunction<Constraint> signature, int nbActualArguments) {
        return signature.apply(nbActualArguments - 1) == null;
    }

    private static int getNbParameters(IntFunction<Constraint> signature) {
        int index = 0;
        while (signature.apply(index) != null) {
            ++index;
        }
        return index;
    }

    private static String getMessage(CallExpressionTree tree, int parametersNumber, int argumentsNumber) {
        ExpressionTree callee = TooManyArgumentsCheck.getCallee(tree);
        String calleeName = callee.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION}) ? "This function" : (callee.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) ? "\"" + ((DotMemberExpressionTree)callee).property().name() + "\"" : "\"" + CheckUtils.asString((Tree)callee) + "\"");
        return String.format(MESSAGE, calleeName, parametersNumber, parametersNumber == 1 ? "" : "s", argumentsNumber, argumentsNumber > 1 ? "were" : "was");
    }

    private static ExpressionTree getCallee(CallExpressionTree callExpression) {
        return CheckUtils.removeParenthesis(callExpression.callee());
    }

    private boolean shouldCheck(CallExpressionTree callExpression) {
        if (this.alreadyHasIssueOn((Tree)callExpression)) {
            return false;
        }
        ExpressionTree callee = TooManyArgumentsCheck.getCallee(callExpression);
        if (callee.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            String functionName = ((DotMemberExpressionTree)callee).property().name();
            return !BUILT_IN_FUNCTIONS_TO_IGNORE.contains(functionName);
        }
        return true;
    }

    private class TreeVisitorCheck
    extends DoubleDispatchVisitor {
        private TreeVisitorCheck() {
        }

        public void visitCallExpression(CallExpressionTree tree) {
            FunctionTree functionTree = this.getFunction(tree);
            if (functionTree != null) {
                int parametersNumber = functionTree.parameterList().size();
                int argumentsNumber = tree.arguments().parameters().size();
                if (!this.hasRestParameter(functionTree) && !this.builtInArgumentsUsed(functionTree) && argumentsNumber > parametersNumber) {
                    String message = TooManyArgumentsCheck.getMessage(tree, parametersNumber, argumentsNumber);
                    TooManyArgumentsCheck.this.addUniqueIssue((Tree)tree.arguments(), message, new IssueLocation(functionTree.parameterClause(), "Formal parameters"));
                }
            }
            super.visitCallExpression(tree);
        }

        private boolean hasRestParameter(FunctionTree functionTree) {
            List parameters = functionTree.parameterList();
            return !parameters.isEmpty() && ((Tree)parameters.get(parameters.size() - 1)).is(new Tree.Kind[]{Tree.Kind.REST_ELEMENT});
        }

        @Nullable
        private FunctionTree getFunction(CallExpressionTree tree) {
            TypeSet types = tree.callee().types();
            if (types.size() == 1 && ((Type)types.iterator().next()).kind().equals((Object)Type.Kind.FUNCTION)) {
                return ((FunctionType)types.iterator().next()).functionTree();
            }
            return null;
        }

        private boolean builtInArgumentsUsed(FunctionTree tree) {
            Scope scope = TooManyArgumentsCheck.this.getContext().getSymbolModel().getScope((Tree)tree);
            if (scope == null) {
                throw new IllegalStateException("No scope found for FunctionTree");
            }
            Symbol argumentsBuiltInVariable = scope.lookupSymbol("arguments");
            if (argumentsBuiltInVariable == null) {
                if (!tree.is(new Tree.Kind[]{Tree.Kind.ARROW_FUNCTION})) {
                    throw new IllegalStateException("No 'arguments' symbol found for function scope");
                }
                return false;
            }
            boolean isUsed = !argumentsBuiltInVariable.usages().isEmpty();
            return argumentsBuiltInVariable.builtIn() && isUsed;
        }
    }
}

