/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S1751")
public class UnconditionalJumpStatementCheck
extends SubscriptionVisitorCheck {
    private static final Tree.Kind[] LOOP_KINDS = new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT};

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.BREAK_STATEMENT, (Object)Tree.Kind.CONTINUE_STATEMENT, (Object)Tree.Kind.RETURN_STATEMENT, (Object)Tree.Kind.THROW_STATEMENT);
    }

    public void visitNode(Tree tree) {
        Tree parent = CheckUtils.parent(tree);
        while (parent.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            parent = CheckUtils.parent(parent);
        }
        if (!parent.is(LOOP_KINDS)) {
            return;
        }
        IterationStatementTree loopTree = (IterationStatementTree)parent;
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONTINUE_STATEMENT}) || !parent.is(new Tree.Kind[]{Tree.Kind.FOR_IN_STATEMENT}) && !UnconditionalJumpStatementCheck.canExecuteMoreThanOnce(loopTree)) {
            SyntaxToken keyword = ((JavaScriptTree)tree).getFirstToken();
            this.addIssue((Tree)keyword, String.format("Remove this \"%s\" statement or make it conditional", keyword.text()));
        }
    }

    private static boolean canExecuteMoreThanOnce(IterationStatementTree loopTree) {
        ControlFlowGraph cfg = CheckUtils.buildControlFlowGraph((Tree)loopTree);
        for (CfgBranchingBlock block : Iterables.filter((Iterable)cfg.blocks(), CfgBranchingBlock.class)) {
            if (!loopTree.equals(block.branchingTree()) || !UnconditionalJumpStatementCheck.hasPredecessorInsideLoopBody(block, loopTree)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPredecessorInsideLoopBody(CfgBranchingBlock conditionBlock, IterationStatementTree loopTree) {
        for (CfgBlock loopPredecessor : conditionBlock.predecessors()) {
            ForStatementTree forTree;
            List predecessorElements = loopPredecessor.elements();
            Tree predecessorLastElement = (Tree)predecessorElements.get(predecessorElements.size() - 1);
            if (loopTree.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT}) && (forTree = (ForStatementTree)loopTree).update() != null && forTree.update().equals(predecessorLastElement)) {
                return !loopPredecessor.predecessors().isEmpty();
            }
            StatementTree loopBody = loopTree.statement();
            if (!CheckUtils.isDescendant(predecessorLastElement, (Tree)loopBody)) continue;
            return true;
        }
        return false;
    }
}

