/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3735")
public class VoidUseCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove \"void\" operator";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VOID);
    }

    public void visitNode(Tree tree) {
        this.addIssue((Tree)((UnaryExpressionTree)tree).operator(), MESSAGE);
    }
}

