/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.BuiltInFunctionSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;

@Rule(key="S3782")
public class ArgumentTypesCheck
extends SeCheck {
    private static final String MESSAGE = "Change this argument to the documented type%s.";
    private static final Map<Constraint, String> CONSTRAINT_TO_STRING_MAP = ImmutableMap.builder().put((Object)Constraint.ANY_NUMBER, (Object)"Number").put((Object)Constraint.ANY_STRING, (Object)"String").put((Object)Constraint.OBJECT, (Object)"Object").put((Object)Constraint.ARRAY, (Object)"Array").put((Object)Constraint.FUNCTION, (Object)"Function").put((Object)Constraint.REGEXP, (Object)"Regexp").put((Object)Constraint.ANY_STRING.or(Constraint.REGEXP), (Object)"String or RegExp").put((Object)Constraint.ANY_STRING.or(Constraint.FUNCTION), (Object)"String or Function").put((Object)Constraint.ANY_STRING.or(Constraint.ARRAY), (Object)"String or Array").put((Object)Constraint.OBJECT.or(Constraint.NULL), (Object)"Object or Null").build();
    private Map<Tree, Optional<String>> hasIssue = new HashMap<Tree, Optional<String>>();

    public void startOfExecution(Scope functionScope) {
        this.hasIssue.clear();
    }

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        IntFunction signature;
        CallExpressionTree callExpression;
        SeparatedList arguments;
        SymbolicValue calleeValue;
        if (element.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && (calleeValue = currentState.peekStack((arguments = (callExpression = (CallExpressionTree)element).arguments().parameters()).size())) instanceof BuiltInFunctionSymbolicValue && (signature = ((BuiltInFunctionSymbolicValue)calleeValue).signature()) != null) {
            this.check(signature, currentState, (List<Tree>)arguments);
        }
    }

    private void check(IntFunction<Constraint> signature, ProgramState currentState, List<Tree> arguments) {
        int i;
        List argumentValues = new ArrayList<SymbolicValue>();
        for (i = 0; i < arguments.size(); ++i) {
            argumentValues.add(currentState.peekStack(i));
        }
        argumentValues = Lists.reverse(argumentValues);
        for (i = 0; i < argumentValues.size(); ++i) {
            Tree argumentTree = arguments.get(i);
            String errorMessage = ArgumentTypesCheck.errorMessage(signature.apply(i), currentState, (SymbolicValue)argumentValues.get(i));
            if (errorMessage == null) {
                this.hasIssue.put(argumentTree, Optional.empty());
                continue;
            }
            if (this.hasIssue.containsKey(argumentTree)) continue;
            this.hasIssue.put(argumentTree, Optional.of(errorMessage));
        }
    }

    @Nullable
    private static String errorMessage(@Nullable Constraint argumentConstraint, ProgramState currentState, SymbolicValue argumentValue) {
        Constraint actualConstraint;
        if (argumentConstraint != null && argumentConstraint.isIncompatibleWith(actualConstraint = currentState.getConstraint(argumentValue))) {
            String type = CONSTRAINT_TO_STRING_MAP.get(argumentConstraint);
            type = type == null ? "" : ": " + type;
            return String.format(MESSAGE, type);
        }
        return null;
    }

    public void endOfExecution(Scope functionScope) {
        for (Map.Entry<Tree, Optional<String>> entry : this.hasIssue.entrySet()) {
            Optional<String> value = entry.getValue();
            if (!value.isPresent()) continue;
            this.addIssue(entry.getKey(), value.get());
        }
    }
}

