/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3524")
public class ArrowFunctionConventionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE_ADD_PARAMETER = "Add parentheses around the parameter of this arrow function.";
    private static final String MESSAGE_ADD_BODY = "Add curly braces and \"return\" to this arrow function body.";
    private static final String MESSAGE_REMOVE_PARAMETER = "Remove parentheses around the parameter of this arrow function.";
    private static final String MESSAGE_REMOVE_BODY = "Remove curly braces and \"return\" from this arrow function body.";
    private static final boolean DEFAULT_PARAMETER_PARENS = false;
    private static final boolean DEFAULT_BODY_BRACES = false;
    @RuleProperty(key="parameter_parens", description="True to require parentheses around parameters. False to forbid them for single parameter.", defaultValue="false")
    private boolean parameterParens = false;
    @RuleProperty(key="body_braces", description="True to require curly braces around function body. False to forbid them for single-return bodies.", defaultValue="false")
    private boolean bodyBraces = false;

    public void setParameterParens(boolean value) {
        this.parameterParens = value;
    }

    public void setBodyBraces(boolean value) {
        this.bodyBraces = value;
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.checkParameterClause(tree);
        this.checkBody(tree);
        super.visitArrowFunction(tree);
    }

    private void checkBody(ArrowFunctionTree tree) {
        StatementTree statement;
        List statements;
        boolean hasBodyBraces = tree.body().is(new Kinds[]{Tree.Kind.BLOCK});
        if (this.bodyBraces && !hasBodyBraces) {
            this.addIssue(tree.body(), MESSAGE_ADD_BODY);
        }
        if (!this.bodyBraces && hasBodyBraces && (statements = ((BlockTree)tree.body()).statements()).size() == 1 && ArrowFunctionConventionCheck.isRemovableReturn(statement = (StatementTree)statements.get(0))) {
            this.addIssue(tree.body(), MESSAGE_REMOVE_BODY);
        }
    }

    private static boolean isRemovableReturn(StatementTree tree) {
        ExpressionTree expression;
        if (tree.is(new Kinds[]{Tree.Kind.RETURN_STATEMENT}) && (expression = ((ReturnStatementTree)tree).expression()) != null && !expression.is(new Kinds[]{Tree.Kind.OBJECT_LITERAL})) {
            int lastLine;
            int firstLine = ((JavaScriptTree)expression).getLine();
            return firstLine == (lastLine = ((JavaScriptTree)expression).getLastToken().line());
        }
        return false;
    }

    private void checkParameterClause(ArrowFunctionTree tree) {
        SeparatedList parameters;
        boolean hasParameterParens = tree.parameterClause().is(new Kinds[]{Tree.Kind.FORMAL_PARAMETER_LIST});
        if (this.parameterParens && !hasParameterParens) {
            this.addIssue(tree.parameterClause(), MESSAGE_ADD_PARAMETER);
        }
        if (!this.parameterParens && hasParameterParens && (parameters = ((ParameterListTree)tree.parameterClause()).parameters()).size() == 1 && ((Tree)parameters.get(0)).is(new Kinds[]{Tree.Kind.BINDING_IDENTIFIER})) {
            this.addIssue(tree.parameterClause(), MESSAGE_REMOVE_PARAMETER);
        }
    }
}

