/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="BitwiseOperators")
public class BitwiseOperatorsCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove the use of \"%s\" operator.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.BITWISE_AND).add((Object)Tree.Kind.BITWISE_OR).add((Object)Tree.Kind.BITWISE_XOR).add((Object)Tree.Kind.BITWISE_COMPLEMENT).add((Object)Tree.Kind.LEFT_SHIFT).add((Object)Tree.Kind.RIGHT_SHIFT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT).add((Object)Tree.Kind.AND_ASSIGNMENT).add((Object)Tree.Kind.OR_ASSIGNMENT).add((Object)Tree.Kind.XOR_ASSIGNMENT).add((Object)Tree.Kind.LEFT_SHIFT_ASSIGNMENT).add((Object)Tree.Kind.RIGHT_SHIFT_ASSIGNMENT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT).build();
    }

    public void visitNode(Tree tree) {
        SyntaxToken operator = tree.is(new Kinds[]{Tree.Kind.BITWISE_COMPLEMENT}) ? ((UnaryExpressionTree)tree).operator() : (tree instanceof BinaryExpressionTree ? ((BinaryExpressionTree)tree).operator() : ((AssignmentExpressionTree)tree).operator());
        this.addIssue((Tree)operator, String.format(MESSAGE, operator.text()));
    }
}

