/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3509")
public class DefaultParameterSideEffectCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove the side effects from this default assignment of \"%s\".";
    private InitializedBindingElementTree currentParameterWithDefault = null;

    public void visitParameterList(ParameterListTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            for (Tree parameter : tree.parameters()) {
                if (!parameter.is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) continue;
                this.currentParameterWithDefault = (InitializedBindingElementTree)parameter;
                this.scan(parameter);
                this.currentParameterWithDefault = null;
            }
        } else {
            super.visitParameterList(tree);
        }
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(new Kinds[]{KindSet.INC_DEC_KINDS}) && this.currentParameterWithDefault != null) {
            this.addIssue((Tree)this.currentParameterWithDefault, String.format(MESSAGE, CheckUtils.asString((Tree)this.currentParameterWithDefault.left())));
            this.currentParameterWithDefault = null;
        }
        super.visitUnaryExpression(tree);
    }
}

