/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQuerySelectorOptimizationCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;

@Rule(key="S2714")
public class ElementUsedWithClassSelectorCheck
extends AbstractJQuerySelectorOptimizationCheck {
    private static final String MESSAGE = "Remove \"%s\" in this selector.";
    private static final Pattern elementUsedWithClassSelectorPattern = Pattern.compile("(\\w+)\\.([\\w_-]+)");

    @Override
    protected void visitSelector(String selector, CallExpressionTree tree) {
        Matcher matcher = elementUsedWithClassSelectorPattern.matcher(selector);
        if (tree.arguments().parameters().size() == 1 && matcher.matches()) {
            this.addIssue((Tree)tree, String.format(MESSAGE, matcher.group(1)));
        }
    }
}

