/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.DefaultExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.FileIssue;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3317")
public class FileNameDiffersFromClassCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Rename this file to \"%s\".";
    private static final EnumSet<Symbol.Kind> CONSIDERED_KINDS = EnumSet.of(Symbol.Kind.CLASS, Symbol.Kind.CONST_VARIABLE, Symbol.Kind.FUNCTION);
    private boolean isOnlyExport = true;
    private String nameOfExported = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.DEFAULT_EXPORT_DECLARATION, (Object)Tree.Kind.NAMESPACE_EXPORT_DECLARATION, (Object)Tree.Kind.NAMED_EXPORT_DECLARATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.DEFAULT_EXPORT_DECLARATION})) {
            Tree exported = ((DefaultExportDeclarationTree)tree).object();
            if (exported.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
                Symbol symbol = ((IdentifierTree)exported).symbol();
                if (symbol != null && CONSIDERED_KINDS.contains(symbol.kind())) {
                    this.nameOfExported = symbol.name();
                }
            } else if (exported.is(new Kinds[]{Tree.Kind.CLASS_DECLARATION})) {
                this.nameOfExported = ((ClassTree)exported).name().name();
            } else if (exported.is(new Kinds[]{Tree.Kind.FUNCTION_DECLARATION})) {
                this.nameOfExported = ((FunctionDeclarationTree)exported).name().name();
            }
        } else {
            this.isOnlyExport = false;
        }
    }

    public void leaveFile(Tree scriptTree) {
        String fileName;
        if (this.isOnlyExport && this.nameOfExported != null && !"index".equals(fileName = this.getContext().getJavaScriptFile().fileName().split("\\.")[0]) && !this.nameOfExported.equals(fileName)) {
            this.addIssue((Issue)new FileIssue((JavaScriptCheck)this, String.format(MESSAGE, this.nameOfExported)));
        }
        this.isOnlyExport = true;
        this.nameOfExported = null;
    }
}

