/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Iterator;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1472")
public class FunctionCallArgumentsOnNewLineCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Make those call arguments start on line %s";

    public void visitCallExpression(CallExpressionTree tree) {
        int argumentsLine;
        int calleeLastLine = this.getLastLine((Tree)tree.callee());
        if (calleeLastLine != (argumentsLine = ((JavaScriptTree)tree.arguments()).getLine())) {
            this.addIssue((Tree)tree.arguments(), String.format(MESSAGE, calleeLastLine));
        }
        super.visitCallExpression(tree);
    }

    private int getLastLine(Tree tree) {
        JavaScriptTree jsTree = (JavaScriptTree)tree;
        if (jsTree.isLeaf()) {
            return jsTree.getLine();
        }
        return this.getLastLine(this.getLastElement(jsTree.childrenIterator()));
    }

    public Tree getLastElement(Iterator<Tree> itr) {
        Tree lastElement = itr.next();
        while (itr.hasNext()) {
            lastElement = itr.next();
        }
        return lastElement;
    }
}

