/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="FunctionDeclarationsWithinBlocks")
public class FunctionDeclarationsWithinBlocksCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Do not use function declarations within blocks.";

    public void visitBlock(BlockTree tree) {
        for (StatementTree stmt : tree.statements()) {
            if (!stmt.is(new Kinds[]{Tree.Kind.FUNCTION_DECLARATION})) continue;
            this.addIssue((Tree)((FunctionDeclarationTree)stmt).functionKeyword(), MESSAGE);
        }
        super.visitBlock(tree);
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        if (tree.body().is(new Kinds[]{Tree.Kind.BLOCK})) {
            this.scan(((BlockTree)tree.body()).statements());
        } else {
            super.visitArrowFunction(tree);
        }
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.scan(tree.body().statements());
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.scan(tree.body().statements());
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.scan(tree.body().statements());
    }
}

