/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.GeneratorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3531")
public class GeneratorWithoutYieldCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Add a \"yield\" statement to this generator.";
    private Deque<Boolean> hasYieldStack = new ArrayDeque<Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.GENERATOR_DECLARATION, (Object)Tree.Kind.GENERATOR_METHOD, (Object)Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, (Object)Tree.Kind.YIELD_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.YIELD_EXPRESSION})) {
            if (this.hasYieldStack.isEmpty()) {
                return;
            }
            this.hasYieldStack.removeLast();
            this.hasYieldStack.addLast(true);
        } else {
            this.hasYieldStack.addLast(false);
        }
    }

    public void leaveNode(Tree tree) {
        boolean hasYield;
        if (!tree.is(new Kinds[]{Tree.Kind.YIELD_EXPRESSION}) && !(hasYield = this.hasYieldStack.removeLast().booleanValue())) {
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, GeneratorWithoutYieldCheck.getPrimaryLocation(tree)));
        }
    }

    private static IssueLocation getPrimaryLocation(Tree tree) {
        Object lastTree;
        SyntaxToken firstTree;
        if (tree.is(new Kinds[]{Tree.Kind.GENERATOR_DECLARATION})) {
            FunctionDeclarationTree functionDeclarationTree = (FunctionDeclarationTree)tree;
            firstTree = functionDeclarationTree.functionKeyword();
            lastTree = functionDeclarationTree.name();
        } else if (tree.is(new Kinds[]{Tree.Kind.GENERATOR_METHOD})) {
            GeneratorMethodDeclarationTree methodDeclarationTree = (GeneratorMethodDeclarationTree)tree;
            firstTree = methodDeclarationTree.starToken();
            lastTree = methodDeclarationTree.name();
        } else {
            FunctionExpressionTree functionExpressionTree = (FunctionExpressionTree)tree;
            firstTree = functionExpressionTree.functionKeyword();
            lastTree = functionExpressionTree.name() != null ? functionExpressionTree.name() : functionExpressionTree.star();
        }
        return new IssueLocation((Tree)firstTree, (Tree)lastTree, MESSAGE);
    }
}

